/***************************************************************************
begin                : Mon Jan 28 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFDOC_H
#define KMFDOC_H

//project includes
#include "iptchain.h"
#include "iptrule.h"
#include "iptruleoption.h"
#include "iptable.h"
#include "kmfnetzone.h"
#include "netfilterobject.h"

// qt includes
#include "tqdict.h"
#include "tqvaluelist.h"
#include "tqptrlist.h"
#include "tqstring.h"
#include "tqobject.h"

// kde includes
#include "kurl.h"

/**
  *@author Christian Hubinger
  */
class KURL;

namespace KMF {
class KMFErrorHandler;
class KMFError;

class KMFNetwork;
class KMFTarget;

//############# Start class KMFDoc ###############
/**
	KMFDoc is the base class for all document classes in KMyFirewall.
	It provides the most common features a document class should have
	e.g. undo/redo setUrl() setFilename() etc. and lots of abstarct methods
	that need to be implemented by a document class.
*/

class KDE_EXPORT KMFDoc : public NetfilterObject {
	Q_OBJECT
  TQ_OBJECT
public:
	KMFDoc( NetfilterObject* parent, const char* name );
	virtual ~KMFDoc();


	/** resets the document to the initial values */
	virtual void clear() = 0;

//	/** return a TQString containing the documents script to 
//		setup the firewall configuration */
//	virtual const TQString& compile() = 0;
	
	/** Writes the xml-representation of this document a String and returns it. */
	virtual const TQString& getXMLRuleset();

	/** return true if the document is in it's initial state */
	virtual bool isEmpty() = 0;

//	/** Writes the shellscrip that contains the iptables commands to settup
//		the firewall to file.
//		If file = TQString() a SaveAs dialog will popup. */
//	KMFError* createFirewallScript( const TQString& fi );

//	/** Return DomDocument of this Chain */
// 	virtual const TQDomDocument& getDOMTree() = 0;

	/** Return String representation of the DomDocument generated by const TQDomDocument& getDOMTree() */
	virtual const TQString& getXMLSniplet();

	/** Load configuratuion from the TQDomDocument */
//  	virtual void loadXML( const TQDomDocument&, TQStringList& errors ) = 0;
	
	/** Load configuratuion from the TQDomDocument */
//  	virtual void loadXML( TQDomNode, TQStringList& errors ) = 0;

	/** Save the rule set to the given file defined by the KURL */
	virtual KMFError* exportXMLRuleset( bool promptFile, bool asTemplate );
		
	/** Get the File dialog filter string for the document type */	
	virtual const TQString& getFileDialogFilter() = 0;

	/** Load the ruleset from the given url */
	virtual void parseDocument( const KURL&, TQStringList& errors ) = 0;
	
	/** return the documents KURL pointer */
	KURL& url();
	
	bool newSavePathNeeded();
	void resetUrl();
	
	/** Set Description for this Object */
// 	virtual void setDescription( const TQString& ) = 0;
	
	/** Return the Object's Description */
/*	const TQString description() const {
		return m_description;
	};*/
	
	/** Set Name for this Object */
// 	virtual void setName( const TQString& ) = 0;
	
	/** Return the Object's Description */
	virtual const TQString& docName();
	
	
	// void objChanged();
// 	void objChanged( int );
	
	/** update the View */
	void updateView();
	
protected:
	virtual KMFError* exportXMLRuleset( const KURL& );	
	virtual void initDoc() = 0;

	KURL m_url;
	KMFErrorHandler *m_err_handler;
	KMFError *m_err;
	bool m_newSavePathNeeded;
	
signals:
	void documentChanged();
	void documentChanged( KMFDoc* );
	void sigEnableUndo( bool );
	void sigEnableRedo( bool );

};
}




#endif
