//
// C++ Interface: kmfiptablesscriptgenerator
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFPFSCRIPTGENERATOR_H
#define KMFPFSCRIPTGENERATOR_H

/**
@author Christian Hubinger
*/
// QT includes
#include <tqstring.h>
#include <tqobject.h>
#include <tqtextstream.h>

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

namespace KMF {
class IPTable;
class KMFIPTDoc;

class KMFPFScriptGenerator{
public:
    KMFPFScriptGenerator();

    ~KMFPFScriptGenerator();

	const TQString& compile( KMFIPTDoc* );
	
	
private:
	// Script Generating methods, acting on m_stream
	void printScriptTableRules( IPTable *tbl );
	void printScriptTableChainDefinition( IPTable *tbl );
	void printScriptStartFunction();
	void printScriptStopFunction();
	void printScriptModuleLoad();
	void printScriptHeader(); 
	void printScriptExecLogic(); 
	
	const TQString& printScriptDebug( const TQString&, bool newLine = true);

	
private: // DATA
	KMFIPTDoc *m_iptDoc;
	TQTextOStream *m_stream;
};
}
#endif
