/**************************************************************************
*   Copyright (C) 2005 by Christian Hubinger                              *
*   e9806056@student.tuwien.ac.at                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/


// QT includes
#include <tqlcdnumber.h>
#include <tqlayout.h>

// KDE includes
#include <kglobal.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kprocess.h>

// Project includes
#include "kmfsystray.h"
#include "kmfiptwatcher.h"
#include "mainwidget.h"

#include "../core/kmfiptdoc.h"
#include "../core/kmfappstate.h"

KMFSysTray::KMFSysTray( TQWidget* w ) :  KSystemTray ( w ) , DCOPObject( "KMFSysTray" ) {
	mainView = w;
	ksConfig = kapp->config();
	KMFIPTWatcher *watch = new KMFIPTWatcher( this, "KMFIPTWatcher" );

	baseIcon = KSystemTray::loadIcon( "kmyfirewall" );
	setPixmap( baseIcon );
	
	// Connect the watch deamon
	connect( watch, TQT_SIGNAL( sigUpdateActive( bool ) ), this, TQT_SLOT( slotSetRunningStatus( bool ) ) );
	connect( watch, TQT_SIGNAL( sigUpdateRuleCount( const TQString&, const TQString&, int ) ), 
		this, TQT_SIGNAL( sigUpdateRuleCount( const TQString&, const TQString&, int ) ) );

	connect( watch, TQT_SIGNAL( sigUpdateIPTDoc( KMFIPTDoc* ) ), 
		this, TQT_SIGNAL( sigUpdateIPTDoc( KMFIPTDoc* ) ) );

	connect( this, TQT_SIGNAL( sigQueryDetails( bool ) ), watch, TQT_SLOT( slotQueryDetails( bool ) ) );

	// Connect view
	connect( w, TQT_SIGNAL( closing() ), this, TQT_SLOT ( slotDetailsClosed() ) );
	connect( w, TQT_SIGNAL( showing() ), this, TQT_SLOT ( slotQueryDetails() ) );
	connect( this, TQT_SIGNAL( sigUpdateIPTDoc( KMFIPTDoc* ) ), w, TQT_SLOT( slotLoadDoc( KMFIPTDoc* ) ) );


	initMenu();
	
	show();
	emit sigQueryDetails( false );
	KMFAppState::setUpAndRunning( true );
	KMFAppState::setHasOpenDoc( true );
}


KMFSysTray::~KMFSysTray() {}

void KMFSysTray::initMenu() {
	KPopupMenu* menu = contextMenu ();
	menu->insertItem( KGlobal::iconLoader()->loadIcon( "kmyfirewall", KIcon::Small ), i18n( "Launch KMyFirewall..."), this, TQT_SLOT( slotLaunchKMF() ), CTRL+Key_K );
	
}

void KMFSysTray::slotSetRunningStatus( bool on ) {
	if ( on ) {
		baseIcon = KSystemTray::loadIcon( "kmyfirewall" );
	} else {
		baseIcon = KSystemTray::loadIcon( "kmyfirewall" );
	}
	setPixmap( baseIcon );	
}



void KMFSysTray::slotLaunchKMF () {
	KProcess *childproc = new KProcess();
	*childproc << "kdesu";
 	*childproc << "kmyfirewall";
	childproc->start( KProcess:: DontCare, KProcess::NoCommunication );
}

void KMFSysTray::slotShowDetails() {
	kdDebug() << "MFSysTray::slotshowDetails()" <<  endl;
	slotQueryDetails();
	mainView->show();
	
}

void KMFSysTray::slotQueryDetails() {
	emit sigQueryDetails( true );
}

void KMFSysTray::slotDetailsClosed() {
	kdDebug() << "KMFSysTray::slotDetailsClosed()" <<  endl;
	emit sigQueryDetails( false );	
}

void KMFSysTray::about() {
/*	if(!_aboutData) {
      _aboutData = new KAboutData("KMFSysTray", I18N_NOOP("KMFSysTray"), 
              "1.0", I18N_NOOP("KMyFirewall Pannel Applet.\n\n"
              "Some basic inform<tion about your running iptables rules"),
              KAboutData::License_GPL_V2, "(c) 2005, Christian Hubinger");
      _aboutData->addAuthor("Christian Hubinger", 0, "e9806056@student.tuwien.ac.at");
			
	}
 	KAboutApplication dialog(_aboutData);
	dialog.show();*/
}


void KMFSysTray::help() {
	KMessageBox::information( 0, i18n( "This is a help box" ) );
}


void KMFSysTray::preferences() {
	KMessageBox::information( 0, i18n( "This is a preferences box" ) );
}

int KMFSysTray::widthForHeight( int  ) const {
	return width();
}

int KMFSysTray::heightForWidth( int  ) const {
	return height();
}

void KMFSysTray::resizeEvent( TQResizeEvent *e ) {}


// extern "C" {
// 	KPanelApplet * init( TQWidget * parent, const TQString & configFile ) {
// 		KGlobal::locale() ->insertCatalogue( "kmfsystray" );
// 		return new KMFSysTray( configFile, KPanelApplet::Normal,
// 		                       KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
// 		                       parent, "kmfsystray" );
// 	}
// }


