/**
 * Copyright (C) 2002-2003 by Koos Vriezen <koos.vriezen@gmail.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KMPLAYER_KOFFICE_PART_H
#define KMPLAYER_KOFFICE_PART_H

#include <config.h>
#include <kmediaplayer/player.h>
#include <kparts/browserextension.h>
#include <kparts/factory.h>
#include <kurl.h>
#ifdef HAVE_KOFFICE
#include <koDocument.h>
#include <koView.h>
#endif //HAVE_KOFFICE
#include <tqobject.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <tqguardedptr.h>
#include <tqregexp.h>
#include "kmplayerview.h"
#include "kmplayersource.h"


class KProcess;
class KAboutData;
class KMPlayer;
class KInstance;
class KConfig;
class TQIODevice;

#ifdef HAVE_KOFFICE
class KOfficeMPlayer;

class KOfficeMPlayerView : public KoView {
    Q_OBJECT
  TQ_OBJECT
public:
    KOfficeMPlayerView (KOfficeMPlayer* part, TQWidget* parent, const char* name = 0 );
    ~KOfficeMPlayerView ();
    void updateReadWrite(bool) {}
private:
    KMPlayer::View * m_view;
    TQGuardedPtr <TQWidget> m_oldparent;
};

class KOfficeMPlayer : public KoDocument {
    Q_OBJECT
  TQ_OBJECT
public:
    KOfficeMPlayer (TQWidget *parentWidget = 0, const char *widgetName = 0, TQObject* parent = 0, const char* name = 0, bool singleViewMode = false);
    ~KOfficeMPlayer ();

    virtual void paintContent (TQPainter& painter, const TQRect& rect,
            bool transparent = false, double zoomX = 1.0, double zoomY = 1.0);
    virtual bool initDoc ();
    virtual bool loadXML (TQIODevice *, const TQDomDocument &);
    virtual bool loadOasis (const TQDomDocument &, KoOasisStyles &, const TQDomDocument &, KoStore *);
    virtual TQDomDocument saveXML ();
    virtual TQCString mimeType() const { return "application/x-kmplayer"; }

    KMPlayer * player () const { return m_player; }
protected:
    virtual KoView* createViewInstance (TQWidget* parent, const char* name);
private:
    KConfig * m_config;
    KMPlayer * m_player;
    KOfficeMPlayerView * m_view; 
};
#endif //HAVE_KOFFICE

#endif
