/* ============================================================
 * File  : gallerysink.h
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Based On Work By: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2007-01-27
 *
 * Copyright 2007 by Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef GALLERYSINK_H
#define GALLERYSINK_H

#include <tqobject.h>
#include <kurl.h>

#include "../../sink.h"
#include "galleryform.h"

namespace KIO
{
    class Job;
}

class KURL;
template <class T> class TQValueList;

namespace KIPISyncPlugin
{

class GalleryCollection;
class GalleryItem;

class GallerySink : public Sink
{ 
public:
  enum State {
      GE_LOGIN = 0,
      GE_LISTALBUMS,
      GE_LISTPHOTOS,
      GE_CREATEALBUM,
      GE_ADDPHOTO
  };

  GallerySink(unsigned int sinkId, TQString name, KConfig* pConfig, KWallet::Wallet* pWallet, GalleryVersion version);
  ~GallerySink();

  const KIPI2::CollectionList* getCollections();
  
  void Save(KConfig* pConfig, KWallet::Wallet* pWallet);
  
  bool Connect();

  /*
  bool loggedIn() const;

  void login( const KURL& url, const TQString& name,
              const TQString& passwd );
  void listAlbums();
  void listPhotos( const TQString& albumName );
  void createAlbum( const TQString& parentAlbumName,
                    const TQString& albumName,
                    const TQString& albumTitle,
                    const TQString& albumCaption );
  bool addPhoto( const TQString& albumName,
                  const TQString& photoPath,
                  const TQString& caption=TQString(),
                  bool rescale=false, int maxDim=600);

  void cancel();
  */
private:
  GalleryVersion mVersion;
  TQString        mAuthToken;
  
  TQString        mName;
  KURL           mURL;
  TQString        mUsername;
  TQString        mPassword;
  
  State          mState;
  TQString    m_cookie;
  KURL       m_url;
  KIO::Job*      mpJob;
  bool       m_loggedIn;
  TQByteArray     mBuffer;
  /*
  void parseResponseLogin(const TQByteArray &data);
  void parseResponseListAlbums(const TQByteArray &data);
  void parseResponseListPhotos(const TQByteArray &data);
  void parseResponseCreateAlbum(const TQByteArray &data);
  void parseResponseAddPhoto(const TQByteArray &data);

signals:
  void signalError( const TQString& msg );
  void signalLoginFailed( const TQString& msg );
  void signalBusy( bool val );
  void signalAlbums( const TQValueList<GAlbum>& albumList );
  void signalPhotos( const TQValueList<GPhoto>& photoList );
  void signalAddPhotoSucceeded( );
  void signalAddPhotoFailed( const TQString& msg );

private slots:
  void data(KIO::Job *job, const TQByteArray &data);
  void slotResult (KIO::Job *job);
  */
};

}

#endif /* GALLERYTALKER_H */
