/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-01
 * Description : a kipi plugin to e-mailing images
 *
 * Copyright (C) 2003-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef SENDIMAGESDIALOG_H
#define SENDIMAGESDIALOG_H

// TQt includes.

#include <tqstring.h>
#include <tqguardedptr.h>

// KDE includes.

#include <kdialogbase.h>
#include <klistbox.h>
#include <kio/previewjob.h>
#include <kurl.h>

// LibKipi includes.

#include <libkipi/interface.h>
#include <libkipi/imagecollection.h>
#include <libkipi/imageinfo.h>

// Local includes.

#include "kpaboutdata.h"

class TQComboBox;
class TQGroupBox;
class TQLabel;
class TQCheckBox;
class TQFrame;
class TQPushButton;
class TQFileInfo;

class KFileItem;
class KIntNumInput;
class KListBox;
class KSqueezedTextLabel;
class KURLRequester;

namespace KIPISendimagesPlugin
{

class ListImageItems : public KListBox
{
    Q_OBJECT
  TQ_OBJECT

public:

    ListImageItems(TQWidget *parent=0, const char *name=0);

signals:

    void addedDropItems(TQStringList filesPath);

protected:

    void dragEnterEvent(TQDragEnterEvent *e);
    void dropEvent(TQDropEvent *e);
};


class SendImagesDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
   
   SendImagesDialog(TQWidget *parent, KIPI::Interface* interface, 
                    const KIPI::ImageCollection& images );
   ~SendImagesDialog();

   KIntNumInput   *m_imageCompression;
   KIntNumInput   *m_attachmentlimit;

   TQComboBox      *m_imagesFormat;
   TQComboBox      *m_imagesResize;
   TQComboBox      *m_mailAgentName;

   TQCheckBox      *m_addComments;
   TQCheckBox      *m_comment2ImageName;
   TQCheckBox      *m_changeImagesProp;
             
   KURLRequester  *m_ThunderbirdBinPath;
      
   KURL::List      m_images2send;
   
public slots:
   
   void slotAddDropItems(TQStringList filesPath);

signals:
   
   void signalAccepted(void);   

private slots:
   
   void slotHelp();
   void slotOk();
   void slotImageSelected( TQListBoxItem * item );
   void slotGotPreview(const KFileItem* , const TQPixmap &pixmap);
   void slotFailedPreview(const KFileItem*);
   void slotImagesFilesButtonAdd(void);
   void slotImagesFilesButtonRem(void);
   void slotThunderbirdBinPathChanged(const TQString&);
   void slotMailAgentChanged(int);

private:
   
   void setupImagesList(void);
   void setupEmailOptions(void);
   void setImagesList(const KURL::List& images);
   void writeSettings(void);
   void readSettings(void);
   void setNbItems(void);

private:

   bool                      m_cancelled;
   
   TQLabel                   *m_labelImageFormat;
   TQLabel                   *m_labelImageSize;
   TQLabel                   *m_mailAgentLabel;
   TQLabel                   *m_labelThunderbirdBinPath;
      
   TQPushButton              *m_addImageButton;
   TQPushButton              *m_remImagesButton;
   TQPushButton              *m_helpButton;
     
   TQProgressDialog          *m_progressDlg;

   TQGroupBox                *m_groupBoxImageList;

   TQLabel                   *m_imageLabel;

   TQFrame                   *page_setupImagesList;
   TQFrame                   *page_setupEmailOptions;
   TQFrame                   *page_about;

   KSqueezedTextLabel       *m_ImageComments;
   KSqueezedTextLabel       *m_ImageAlbum;
   
   KIPI::Interface          *m_interface;
   KIO::PreviewJob          *m_thumbJob;

   KIPIPlugins::KPAboutData *m_about;
   ListImageItems           *m_ImagesFilesListBox;
};

}  // NameSpace KIPISendimagesPlugin

#endif  // SENDIMAGESDIALOG_H
