/* ============================================================
 * File  : gallerytalker.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-11-30
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef GALLERYTALKER_H
#define GALLERYTALKER_H

#include <tqobject.h>
#include <kurl.h>

namespace KIO
{
    class Job;
}

class KURL;
template <class T> class TQValueList;

namespace KIPIGalleryExportPlugin
{

class GAlbum;
class GPhoto;

class GalleryTalker : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:

    enum State {
        GE_LOGIN = 0,
        GE_LISTALBUMS,
        GE_LISTPHOTOS,
        GE_CREATEALBUM,
        GE_ADDPHOTO
    };

    GalleryTalker(TQWidget* parent);
    ~GalleryTalker();

    static void setGallery2(bool usegallery2) {s_using_gallery2 = usegallery2;};
    static bool isGallery2() {return s_using_gallery2;};
    
    static TQString getAuthToken() {return s_authToken;};

    bool loggedIn() const;

    void login( const KURL& url, const TQString& name,
                const TQString& passwd );
    void listAlbums();
    void listPhotos( const TQString& albumName );
    void createAlbum( const TQString& parentAlbumName,
                      const TQString& albumName,
                      const TQString& albumTitle,
                      const TQString& albumCaption );
    bool addPhoto( const TQString& albumName,
                   const TQString& photoPath,
                   const TQString& caption=TQString(),
                   bool  captionIsTitle=true, bool captionIsDescription=false,
                   bool rescale=false, int maxDim=600);

    void cancel();

private:

    TQWidget*   m_parent;
    State      m_state;
    TQString    m_cookie;
    KURL       m_url;
    KIO::Job*  m_job;
    bool       m_loggedIn;
    TQByteArray m_buffer;

    static bool    s_using_gallery2;
    static TQString s_authToken;

private:

    void parseResponseLogin(const TQByteArray &data);
    void parseResponseListAlbums(const TQByteArray &data);
    void parseResponseListPhotos(const TQByteArray &data);
    void parseResponseCreateAlbum(const TQByteArray &data);
    void parseResponseAddPhoto(const TQByteArray &data);

signals:

    void signalError( const TQString& msg );
    void signalLoginFailed( const TQString& msg );
    void signalBusy( bool val );
    void signalAlbums( const TQValueList<GAlbum>& albumList );
    void signalPhotos( const TQValueList<GPhoto>& photoList );
    void signalAddPhotoSucceeded( );
    void signalAddPhotoFailed( const TQString& msg );

private slots:

    void data(KIO::Job *job, const TQByteArray &data);
    void slotResult (KIO::Job *job);
};

}

#endif /* GALLERYTALKER_H */
