/* ============================================================
 * File  : galleries.h
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Date  : 2006-09-04
 * Copyright 2006 by Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef GALLERIES_H
#define GALLERIES_H

#include <tqptrlist.h>
#include <tqlistview.h>

namespace KWallet
{
class Wallet;
}

namespace KIPIGalleryExportPlugin
{

class Gallery
{
public:

    Gallery(const TQString& name = i18n("New Gallery"),
            const TQString& url = TQString("http://www.newgallery.com/"),
            const TQString& username = TQString(),
            const TQString& password = TQString(),
            const unsigned int version = 2,
            const unsigned int galleryId = 0);
    ~Gallery();

    TQString name()           const;
    TQString url()            const;
    TQString username()       const;
    TQString password()       const;
    unsigned int version()   const;
    unsigned int galleryId() const;

    void setName(TQString name);
    void setUrl(TQString url);
    void setUsername(TQString username);
    void setPassword(TQString password);
    void setVersion(unsigned int version);
    void setGalleryId(unsigned int galleryId);

    TQListViewItem* asTQListViewItem(TQListView* pParent);

private:

  TQString mName;
  TQString mUrl;
  TQString mUsername;
  TQString mPassword;
  unsigned int mVersion;

  unsigned int mGalleryId;
};


/* Simple Stub Class to allow easy access to Galleries from GUI elements */
class GalleryTQListViewItem : public TQListViewItem
{
public:
  GalleryTQListViewItem(Gallery* pGallery, TQListView* pParent);

  Gallery* GetGallery();
  void Refresh();
private:
  Gallery* mpGallery;
};


typedef TQPtrList<Gallery> GalleryPtrList;

/* Container class for all Galleries */
class Galleries
{
public:
  Galleries();
  ~Galleries();

  void Add(Gallery* pGallery);
  void Remove(Gallery* pGallery);
  void Save();
  TQListView* asTQListView(TQWidget* pParent);

private:
  void Load();

  KWallet::Wallet* mpWallet;

  GalleryPtrList mGalleries;
  unsigned int mMaxGalleryId;
};


}

#endif /* GALLERIES_H */
