/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqvbox.h>
#include <tqlayout.h>
#include <tqwidget.h>
#include <tqwhatsthis.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tqcombobox.h>
#include <tqcolor.h>

// Include files for KDE

#include <klocale.h>
#include <knuminput.h>
#include <kcolorbutton.h>

// Local includes

#include "filteroptionsdialog.h"
#include "filteroptionsdialog.moc"

namespace KIPIBatchProcessImagesPlugin
{

FilterOptionsDialog::FilterOptionsDialog(TQWidget *parent, int FilterType)
                        : KDialogBase( parent, "FilterOptionsDialog", true,
                          i18n("Filter Options"), Ok|Cancel, Ok, false)
{
    TQWidget* box = new TQWidget( this );
    setMainWidget(box);
    TQVBoxLayout *dvlay = new TQVBoxLayout( box, 10, spacingHint() );
    TQString whatsThis;

    if (FilterType == 0) // Add noise
       {
       TQLabel *m_label_noiseType = new TQLabel (i18n("Noise algorithm:"), box);
       dvlay->addWidget( m_label_noiseType );
       m_noiseType = new TQComboBox( false, box );
       m_noiseType->insertItem(i18n("Uniform"));
       m_noiseType->insertItem(i18n("Gaussian"));
       m_noiseType->insertItem(i18n("Multiplicative"));
       m_noiseType->insertItem(i18n("Impulse"));
       m_noiseType->insertItem(i18n("Laplacian"));
       m_noiseType->insertItem(i18n("Poisson"));
       TQWhatsThis::add( m_noiseType, i18n("<p>Select here the algorithm method which will used "
                                          "to add random noise to the images.") );
       m_label_noiseType->setBuddy( m_noiseType );
       dvlay->addWidget( m_noiseType );
       }

    if (FilterType == 2) // Blur
       {
       TQLabel *m_label_blurRadius = new TQLabel (i18n("Radius:"), box);
       dvlay->addWidget( m_label_blurRadius );
       m_blurRadius = new KIntNumInput(3, box);
       m_blurRadius->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_blurRadius, i18n("<p>Select here the blur radius of the Gaussian, in pixels, "
                                           "not counting the center pixel. For reasonable results, the "
                                           "radius should be larger than deviation. If you use a radius of 0 "
                                           "the blur operations selects a suitable radius.") );
       m_label_blurRadius->setBuddy( m_blurRadius );
       dvlay->addWidget( m_blurRadius );

       TQLabel *m_label_blurDeviation = new TQLabel (i18n("Deviation:"), box);
       dvlay->addWidget( m_label_blurDeviation );
       m_blurDeviation = new KIntNumInput(1, box);
       m_blurDeviation->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_blurDeviation, i18n("<p>Select here the standard deviation of the blur Gaussian, "
                                              "in pixels.") );
       m_label_blurDeviation->setBuddy( m_blurDeviation );
       dvlay->addWidget( m_blurDeviation );
       }

    if (FilterType == 5) // Median
       {
       TQLabel *m_label_medianRadius = new TQLabel (i18n("Radius:"), box);
       dvlay->addWidget( m_label_medianRadius );
       m_medianRadius = new KIntNumInput(3, box);
       m_medianRadius->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_medianRadius, i18n("<p>Select here the median radius of the pixel neighborhood. "
                                             "The algorithm applies a digital filter that improves the quality "
                                             "of noisy images. Each pixel is replaced by the median in a "
                                             "set of neighboring pixels as defined by the radius.") );
       m_label_medianRadius->setBuddy( m_medianRadius );
       dvlay->addWidget( m_medianRadius );
       }


    if (FilterType == 6) // Noise reduction
       {
       TQLabel *m_label_noiseRadius = new TQLabel (i18n("Radius:"), box);
       dvlay->addWidget( m_label_noiseRadius );
       m_noiseRadius = new KIntNumInput(3, box);
       m_noiseRadius->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_noiseRadius, i18n("<p>Select here the noise reduction radius value, in pixels. "
                                            "The algorithm smooths the contours of an image while still "
                                            "preserving edge information. The algorithm works by replacing "
                                            "each pixel with its neighbor closest in value. A neighbor is "
                                            "defined by the radius. If you use a radius of 0 the algorithm "
                                            "selects a suitable radius.") );
       m_label_noiseRadius->setBuddy( m_noiseRadius );
       dvlay->addWidget( m_noiseRadius );
       }

    if (FilterType == 7) // Sharpen
       {
       TQLabel *m_label_sharpenRadius = new TQLabel (i18n("Radius:"), box);
       dvlay->addWidget( m_label_sharpenRadius );
       m_sharpenRadius = new KIntNumInput(3, box);
       m_sharpenRadius->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_sharpenRadius, i18n("<p>Select here the radius of the sharpen Gaussian, in "
                                              "pixels, not counting the center pixel. For reasonable "
                                              "results, the radius should be larger than deviation. "
                                              "if you use a radius of 0 the sharpen operation selects a "
                                              "suitable radius.") );
       m_label_sharpenRadius->setBuddy( m_sharpenRadius );
       dvlay->addWidget( m_sharpenRadius );

       TQLabel *m_label_sharpenDeviation = new TQLabel (i18n("Deviation:"), box);
       dvlay->addWidget( m_label_sharpenDeviation );
       m_sharpenDeviation = new KIntNumInput(1, box);
       m_sharpenDeviation->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_sharpenDeviation, i18n("<p>Select here the sharpen deviation value of the "
                                                 "Laplacian in pixels.") );
       m_label_sharpenDeviation->setBuddy( m_sharpenDeviation );
       dvlay->addWidget( m_sharpenDeviation );
       }

    if (FilterType == 8) // Unsharp
       {
       TQLabel *m_label_unsharpenRadius = new TQLabel (i18n("Radius:"), box);
       dvlay->addWidget( m_label_unsharpenRadius );
       m_unsharpenRadius = new KIntNumInput(3, box);
       m_unsharpenRadius->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_unsharpenRadius, i18n("<p>Select here the radius of the unsharpen Gaussian, "
                                                "in pixels, not counting the center pixel. The algorithm "
                                                "convolve the image with a Gaussian operator of the given "
                                                "radius and standard deviation. For reasonable results, "
                                                "radius should be larger than sigma. If you use a radius of 0 "
                                                "the algorithm selects a suitable radius.") );
       m_label_unsharpenRadius->setBuddy( m_unsharpenRadius );
       dvlay->addWidget( m_unsharpenRadius );

       TQLabel *m_label_unsharpenDeviation = new TQLabel (i18n("Deviation:"), box);
       dvlay->addWidget( m_label_unsharpenDeviation );
       m_unsharpenDeviation = new KIntNumInput(1, box);
       m_unsharpenDeviation->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_unsharpenDeviation, i18n("<p>Select here the unsharpen deviation value of the "
                                                   "Gaussian, in pixels.") );
       m_label_unsharpenDeviation->setBuddy( m_unsharpenDeviation );
       dvlay->addWidget( m_unsharpenDeviation );

       TQLabel *m_label_unsharpenPercent = new TQLabel (i18n("Percent:"), box);
       dvlay->addWidget( m_label_unsharpenPercent );
       m_unsharpenPercent = new KIntNumInput(3, box);
       m_unsharpenPercent->setRange(1, 100, 1, true );
       TQWhatsThis::add( m_unsharpenPercent, i18n("<p>Select here the percentage difference between original "
                                                 "and blurred image which should be added to original.") );
       m_label_unsharpenPercent->setBuddy( m_unsharpenPercent );
       dvlay->addWidget( m_unsharpenPercent );

       TQLabel *m_label_unsharpenThreshold = new TQLabel (i18n("Threshold:"), box);
       dvlay->addWidget( m_label_unsharpenThreshold );
       m_unsharpenThreshold = new KIntNumInput(1, box);
       m_unsharpenThreshold->setRange(0, 20, 1, true );
       TQWhatsThis::add( m_unsharpenThreshold, i18n("<p>Select here the unsharpen threshold value, in "
                                                   "pixels, needed to apply the diffence amount."));
       m_label_unsharpenThreshold->setBuddy( m_unsharpenThreshold );
       dvlay->addWidget( m_unsharpenThreshold );
       }
}

FilterOptionsDialog::~FilterOptionsDialog()
{
}

}  // NameSpace KIPIBatchProcessImagesPlugin
