/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef BATCHPROCESSIMAGESITEM_H
#define BATCHPROCESSIMAGESITEM_H

// Include files for TQt

#include <tqstring.h>
#include <tqobject.h>

// Include files for KDE

#include <klistview.h>

class TQPainter;
class TQListView;

namespace KIPIBatchProcessImagesPlugin
{

class BatchProcessImagesItem : public KListViewItem
{
public:

    BatchProcessImagesItem(TQListView * parent, TQString const & pathSrc, TQString const & nameSrc,
                           TQString const & nameDest, TQString const & result);

    ~BatchProcessImagesItem();

    TQString pathSrc();
    TQString nameSrc();
    TQString nameDest();
    TQString result();
    TQString error();
    TQString outputMess();
    bool overWrote();
    void setDidOverWrite( bool b );

    void changeResult(TQString text);
    void changeError(TQString text);
    void changeNameDest(TQString text);
    void changeOutputMess(TQString text);

    void paintCell (TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment);

    void setKey(const TQString& val, bool reverseSort);
    TQString key(int column, bool ascending) const;
    int compare (TQListViewItem * i, int col, bool ascending) const;

private:
    TQString _pathSrc;
    TQString _nameSrc;
    TQString _nameDest;
    TQString _result;
    TQString _error;
    TQString _outputMess;
    bool    _overwrote;
    TQString _key;
    bool    _reverseSort;
};

}  // NameSpace KIPIBatchProcessImagesPlugin

#endif  // BATCHPROCESSIMAGESITEM_H
