/*
 *   profilePropsPage.h
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _PROFILEPROPSPAGE_H_
#define _PROFILEPROPSPAGE_H_

#include "profilePropsPage_ui.h"
#include "pageWidget.h"

class ProfilePropsPage : public ProfilePropsPageUI, public PageWidget
{
  Q_OBJECT
  TQ_OBJECT
public:  
  ProfilePropsPage(TQWidget *parent, const TQString &profile);
  ~ProfilePropsPage();

  virtual void load();
  virtual bool save();

  virtual void setFocus();
  
  virtual TQString subCaption();

  TQString profile() { return m_profile; }

protected slots:
  void slotProfileNameChanged();

private:
  TQString m_profile;
  bool m_fixedProfileDir;
  TQString m_origProfile;
  TQString m_origInstallDir;
};

#endif
