/*
 *   filetypeeditComponent.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "filetypeeditComponent.h"

#include <tqdir.h>
#include <tqdom.h>
#include <tqfileinfo.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <kprocess.h>
#include <ksavefile.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <kurl.h>

#include "kioskrun.h"
#include "kiosksync.h"

FileTypeEditComponent::FileTypeEditComponent( TQObject *parent)
 : Component(parent)
{
}

FileTypeEditComponent::~FileTypeEditComponent()
{
}

void
FileTypeEditComponent::slotSetupPrepare()
{
}

void
FileTypeEditComponent::slotSetupStarted()
{
}

bool
FileTypeEditComponent::setupFinished()
{
   bool result;

   // Install mimetype files
   {
      TQString mimetypeFiles = KioskRun::self()->locateLocal("mime", TQString());
      TQString mimetypeSaveFiles = KioskRun::self()->locateSave("mime", TQString());
      
      KioskSync mimeDir(kapp->mainWidget());
      mimeDir.addDir(mimetypeFiles, KURL());

      TQStringList newMimetypeFiles = mimeDir.listFiles();
   
      for(TQStringList::ConstIterator it = newMimetypeFiles.begin();
          it != newMimetypeFiles.end(); ++it)
      {
         if ((*it).endsWith(".desktop"))
         {
            kdDebug() << "FileTypeEditComponent: New mimetype file %s" << (mimetypeFiles+(*it)) << endl;
            result = KioskRun::self()->install(mimetypeFiles+(*it), mimetypeSaveFiles+(*it));
            if (!result) return false;
         }
      }
   }

   // Install legacy .desktop files
   {
      TQString legacyApplications = KioskRun::self()->locateLocal("apps", TQString());
      TQString legacySaveApplications = KioskRun::self()->locateSave("apps", TQString());
      
      KioskSync legacyDir(kapp->mainWidget());
      legacyDir.addDir(legacyApplications, KURL());

      TQStringList newLegacyApplications = legacyDir.listFiles();
   
      for(TQStringList::ConstIterator it = newLegacyApplications.begin();
          it != newLegacyApplications.end(); ++it)
      {
         if ((*it).endsWith(".desktop") || (*it).endsWith(".kdelnk") || (*it).endsWith(".directory"))
         {
            kdDebug() << "MenueditComponent: New legacy file %s" << (legacyApplications+(*it)) << endl;
            result = KioskRun::self()->install(legacyApplications+(*it), legacySaveApplications+(*it));
            if (!result) return false;
         }
      }
   }

   // Install .desktop files
   {
      TQString xdgApplications = KioskRun::self()->locateLocal("xdgdata-apps", TQString());
      TQString xdgSaveApplications = KioskRun::self()->locateSave("xdgdata-apps", TQString());

      TQDir dir(xdgApplications);
      TQStringList newXdgApplications = dir.entryList(TQDir::All, TQDir::Unsorted);
      newXdgApplications.remove(".");
      newXdgApplications.remove("..");
   
      for(TQStringList::ConstIterator it = newXdgApplications.begin();
          it != newXdgApplications.end(); ++it)
      {
         if ((*it).endsWith(".desktop") || (*it).endsWith(".kdelnk"))
         {
            kdDebug() << "MenueditComponent: New .desktop file %s" << (xdgApplications+(*it)) << endl;
            result = KioskRun::self()->install(xdgApplications+(*it), xdgSaveApplications+(*it));
            if (!result) return false;
         }
      }
   }

   KioskRun::self()->forceSycocaUpdate();

   return true;
}

#include "filetypeeditComponent.moc"
