/*
 *   componentPage.h
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _COMPONENTPAGE_H_
#define _COMPONENTPAGE_H_

#include "componentPage_ui.h"
#include "pageWidget.h"

class KProcess;
class Component;
class ComponentData;

class ComponentPage : public ComponentPageUI, public PageWidget
{
  Q_OBJECT
  TQ_OBJECT
public:  
  ComponentPage( ComponentData *data, Component *component, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~ComponentPage();

  virtual void load();
  virtual bool save();
   
  virtual void setFocus();

  virtual TQString subCaption();

public slots:
  void slotSetup();
  void slotPreview();

protected slots:
  void slotShowNotice();
  void slotSetupDone();
  void slotPreviewDone();
  void slotShowAction(TQListViewItem *item);
  void slotSetupAppRegistered( const TQCString &appid);
  void slotPreviewAppRegistered( const TQCString &appid);

protected:
  void prepareMutableFiles();

private:
  KProcess *m_process;
  ComponentData *m_data;
  Component *m_component;
  bool m_saveSettings;
};

#endif
