/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "parsers.h"
#include "../apt.h"

#include "qhtmlstream.h"

#include <kio/slavebase.h>

namespace Parsers
{
/** Parses the output of apt-cache search */
void Search::operator() (AptProtocol* slave, const TQString& tag, const TQString& value)
{
  static TQMap<TQString, TQString> results;
  static TQString cur_package;
  static TQString query;

  if (tag == "begin")
  {
  	query = value;
    m_result_count = 0;
  }
  else if (tag == "package")
  {
    ++m_result_count;
    cur_package = value;
  }
  else if (tag == "short_desc")
  {
  	results[cur_package] = value;
  }
  else if (tag == "end")
  {
  	// We separate results whose package name matches the query
    // and those who matches only with the description
  	TQString normal, special;
    TQHtmlStream sstream(&special), nstream(&normal);

    // TQMap iteration sorts wrt the key < operator
    // with TQStrings, it means case insensitive sort
  	TQMap<TQString, TQString>::ConstIterator i;
    for (i = results.begin(); i != results.end(); ++i)
    {
    	const TQString key = i.key();
      TQHtmlStream* stream = &nstream;
      if (key == query)
      	stream = &sstream;

      (*stream)
      	<< block("tr")
        <<	block("td")
        <<		block("a") << param("href") << "apt:/show?" + key
        <<      key
        <<    close()
        <<	close() << block("td") << *i << close() << endl
        << close() << endl;
    }

    if (!special.isEmpty())
      *slave << TQString("<table>") + special + TQString("</table>\n<hr>\n");
    *slave << TQString("<table>") + normal + TQString("</table>");

    results.clear();
  }
}
}

