/***************************************************************************
*   Copyright (C) 2003 by Sylvain Joyeux                                  *
*   sylvain.joyeux@m4x.org                                                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KIOAPT_APTCACHE_H
#define KIOAPT_APTCACHE_H

#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqstring.h>
#include <kprocess.h>

class AptProtocol;

/**
@author Sylvain Joyeux
*/
class AptCache : public TQObject {
  Q_OBJECT
  TQ_OBJECT

  typedef void (AptCache::*ReceiveMethod) (const TQStringList& lines);
  ReceiveMethod m_receive;

  // KProcIO messes the stderr and the stdout lines :(
  KProcess m_process;
  TQString m_received_out, m_received_err;

  TQString m_attribute;

  TQString m_installed, m_candidate;

private slots:
  void receivedStdErr(KProcess* process, char* buffer, int len);
  void receivedStdOut(KProcess* process, char* buffer, int len);

private:
  void clear();
  void receiveSearch(const TQStringList& lines);
  void receiveShow(const TQStringList& lines);
  void receivePolicy(const TQStringList& lines);
  void parse_pkgfield(const TQString& data);

public:
  AptCache();
  ~AptCache();

  bool search(const TQString& expression);
  bool show(const TQString& package);
  bool policy(const TQString& package);

  TQString policy_installed() const;
  TQString policy_candidate() const;

signals:
  /** Tags:
   *    warning (warning text)
   *    error (error text)
   *    package (package_name)
   *      short_desc (description)
   *      field (field_name)
   *        package_link (package_name)
   *        data (plain_data)
   *        indent (value)
   *      policy
   *        installed (version)
   *        candidate (version)
   *        version_table
   *          version (version_desc)
   *            location (location_desc)
   *    file (file_name)  [for dpkg]
   * end
   */
  void token(const TQString& tag, const TQString& value);
};

#endif
