/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef HWMONFANSRC_H
#define HWMONFANSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <tqfile.h>
#include <list>

/**
 * HwMonThermalSrc reads fan rpm values from /sys/class/hwmon/\*\/device/fan*_input 
 * that is provided by the hwmon kernel by the lmsensors kernel modules since version 2.6.14.
 * /sys/bus/i2c/devices/\*\/fan*_input is used as a fall back.
 * see /usr/src/linux/Documentation/hwmon/sysfs-interface
 */
class HwMonFanSrc : public LabelSource {
	Q_OBJECT
	TQ_OBJECT //macro which activates signals and slots (tqmoc)
public:
	/**
	 * Creates a new Source from the given File
	 */
	HwMonFanSrc(TQWidget* inParent, const TQFile& inSourceFile, unsigned int inIndex);
	virtual ~HwMonFanSrc();
	
	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(TQWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual TQString fetchValue();

private:
	/**
	 * The file from which the value is read
	 */
	TQFile mSourceFile;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //HWMONFANSRC_H

