/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef HDDTEMPSRC_H
#define HDDTEMPSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <list>

/**
 * HDDTempSrc reads temperature of your harddisk provided by hddtemp
 */
class HDDTempSrc : public LabelSource {
	Q_OBJECT
	TQ_OBJECT //macro which activates signals and slots (tqmoc)

	/**
	 * defines how many bytes are read at once from the network
	 */
	static const TQ_ULONG BUFFERSIZE;

	/**
	 * defines the address
	 */
	static const TQ_UINT32 ADDRESS;

	/**
	 * defines the port
	 */
	static const TQ_UINT16 PORT;

public:
	/**
	 * Creates a new Source from the given File
	 */
	HDDTempSrc(TQWidget* inParent, uint inIndex, const TQString& inDevice, const TQString& inModelName);
	virtual ~HDDTempSrc();

	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(TQWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual TQString fetchValue();

private:
	uint mIndex;
	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //HDDTEMPSRC_H

