/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "hddtempsrc.h"

#include <tqsocketdevice.h>
#include <tqhostaddress.h>
#include <tqcstring.h> 

#include <klocale.h>

//#include <kdebug.h>

const TQ_ULONG HDDTempSrc::BUFFERSIZE = 128;
const TQ_UINT32 HDDTempSrc::ADDRESS = (127<<24)|1;
const TQ_UINT16 HDDTempSrc::PORT = 7634;

HDDTempSrc::HDDTempSrc(TQWidget* inParent, uint inIndex, const TQString& inDevice, const TQString& inModelName):
		LabelSource(inParent),
		mIndex(inIndex),
		mTrigger(this){
	mID = "HDDTemp" + TQString().setNum(inIndex);
	mName = mID;
	mDescription = i18n("This source is provided by hddtemp. (%1, %2)").arg(inDevice).arg(inModelName);
}

HDDTempSrc::~HDDTempSrc(){
}

std::list<Source*>HDDTempSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQSocketDevice sd;
	sd.setBlocking(true);
	if(sd.connect((ADDRESS), PORT)){
		//kdDebug() << "hddtemp is availalble" << endl;
		TQCString tmp(0);
		TQ_LONG numBytes = 0;
		TQ_LONG numTotalBytes = 0;
		do{
			tmp.resize(numTotalBytes+BUFFERSIZE);
			numBytes = sd.readBlock(tmp.data()+numTotalBytes, BUFFERSIZE);
            // numBytes could be -1 too in case of an error!
			numTotalBytes += TQMAX(numBytes, 0);
		}while(numBytes>0);
		sd.close();
		tmp.resize(numTotalBytes+1);	
		//kdDebug() << "following data was read: " << tmp << endl;
		// split the string
		TQStringList sl = TQStringList::split(tmp[0], tmp);
		// create the sources
		if(sl.size() > 0 && sl.size()%4 == 0){
			for(uint i = 0; i < sl.size(); i += 4)
				list.push_back(new HDDTempSrc(inParent, i/4, sl[i], sl[i+1]));
		}
	}//else
		//kdDebug() << "hddtemp is not availalble" << endl; // << sd.error() << endl;
	return list;
}

TQString HDDTempSrc::fetchValue(){
	TQString s = "n/a";
	TQSocketDevice sd;
	sd.setBlocking(true);
	if(sd.connect((ADDRESS), PORT)){
		TQCString tmp(0);
		TQ_LONG numBytes = 0;
		TQ_LONG numTotalBytes = 0;
		do{
			tmp.resize(numTotalBytes+BUFFERSIZE);
			numBytes = sd.readBlock(tmp.data()+numTotalBytes, BUFFERSIZE);
            // numBytes could be -1 too in case of an error!
			numTotalBytes += TQMAX(numBytes, 0);
		}while(numBytes>0);
		sd.close();
		tmp.resize(numTotalBytes+1);
		TQStringList sl = TQStringList::split(tmp[0], tmp);
		if(sl.size() > 0 && sl.size()%4 == 0){
			s = formatTemperature(sl[mIndex*4+2]);
		}
	}
	return s;
}

