#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

if( BUILD_TRANSLATIONS AND NOT DEFINED MSGFMT_EXECUTABLE )
  find_program( MSGFMT_EXECUTABLE msgfmt )
  if( NOT MSGFMT_EXECUTABLE )
    tde_message_fatal( "msgfmt program is required, but was not found on your system" )
  endif( )
endif( )

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )
check_function_exists( getpeereid HAVE_GETPEEREID )

if ( BUILD_KGTK_GTK2 )
    # Check if we have dlvsym...
    find_library(LIBDLVSYM_LIBRARY
                 NAMES dl
                 PATHS /lib /usr/lib /usr/X11R6/lib /usr/local/lib)

    if(LIBDLVSYM_LIBRARY)
        set(HAVE_DLVSYM 1)
        # Determine version of dlsym...
        find_library(LIBDL_LIBRARY
                     NAMES dl
                     PATHS /lib /usr/lib /usr/X11R6/lib /usr/local/lib)

        if(LIBDL_LIBRARY)
            execute_process(COMMAND objdump --dynamic-syms ${LIBDL_LIBRARY}
                            COMMAND grep dlsym
                            OUTPUT_VARIABLE DLSYM_DATA)
            separate_arguments(DLSYM_DATA)
            if (${CMAKE_MAJOR_VERSION} GREATER 2 OR ${CMAKE_MINOR_VERSION} GREATER 4)
                cmake_policy(SET CMP0007 OLD)
            endif (${CMAKE_MAJOR_VERSION} GREATER 2 OR ${CMAKE_MINOR_VERSION} GREATER 4)
            list(GET DLSYM_DATA 4 KGTK_DLSYM_VERSION)
        endif(LIBDL_LIBRARY)
    else(LIBDLVSYM_LIBRARY)
        message("** INFORMATION: You're libdl does not contain dlvsym - SWT apps will not be supported")
    endif(LIBDLVSYM_LIBRARY)
endif ()

# common required stuff
find_package( TQt )
find_package( TDE )
