/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#include "beagle.h"
#include "kerry.h"

#include <kglobal.h>
#include <klocale.h>

extern "C"
{
  KDE_EXPORT KCModule *create_beagle(TQWidget *parent, const char *name)
  {
    KGlobal::locale()->insertCatalogue("kcmbeagle");
    return new KCMBeagle(parent, name);
  }

  KDE_EXPORT KCModule *create_kerry(TQWidget *parent, const char *name)
  {
    KGlobal::locale()->insertCatalogue("kcmbeagle");
    return new KCMKerry(parent, name);
  }
}


