/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "logdialog.h"

#include <klocale.h>
#include <tqlayout.h>
#include <kstandarddirs.h>
#include <dcopref.h>
#include <kdebug.h>
#include <kactivelabel.h>
#include <klistview.h>
#include <tqpixmap.h>
#include <kcombobox.h>
#include <tqfile.h>
#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <tqstringlist.h>

#include "logview.h"

LogDialog::LogDialog(TQWidget *parent): KDialogBase(Plain, i18n("View log"),
	Help|Ok, Cancel, parent, "logDialog", true, false)
{
	m_logFilePath = locateLocal( "data", "keep/keep.log", true );

	TQFrame *page = plainPage();
	TQVBoxLayout *topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
	m_view = new LogView(page,"logDialog");
	topLayout->addWidget( m_view );
	setMainWidget(page);
	
	m_view->logList->setSorting(0,false);

	slotLoadLog();
	resize(600,400);
}

void LogDialog::slotLoadLog()
{
	m_view->logList->clear();
	TQFile file( m_logFilePath );
	if ( file.open( IO_ReadOnly ) ) {
		TQTextStream stream( &file );
		TQString line;
		while ( !stream.atEnd() ) {
			line = stream.readLine(); // line of text excluding '\n'
			TQStringList params = TQStringList::split("\t",line);
			KListViewItem *item = new KListViewItem(m_view->logList,params[0],params[1],params[2]);
		}
		file.close();
	}
}

#include "logdialog.moc"
