/***************************************************************************
                          quantacommon.h  -  description
                             -------------------
    begin                : Sat Jul 27 2002
    copyright            : (C) 2002, 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef QUANTACOMMON_H
#define QUANTACOMMON_H

#include <kdeversion.h>

#include "qtag.h"
#include "node.h"
#include "parser.h"

/**Some common, mostly static functions.
  *@author Andras Mantia
  */

#define DEFAULT_DTD TQString("-//W3C//DTD HTML 4.01 Transitional//EN")

class TQString;
class DCOPReply;
class KURL;
class KStandardDirs;
class TQWidget;
class Tag;

class KConfig;
class KPopupMenu;

/** Describes one abbreviation group */
class Abbreviation{
public:
/*A list with abbreviations in the for of: <template templatename, code> */
  TQMap<TQString, TQString> abbreviations;
  TQStringList dteps;
};


//Quanta main configuration structure
class TQConfig{
public:
          //Tag style options
          uint tagCase;
          uint attrCase;
          TQChar attrValueQuotation;
          bool closeOptionalTags;
          bool closeTags;
          bool updateClosingTags;

          //editor settings
          bool useAutoCompletion;
          bool enableDTDToolbar;
          TQString defaultEncoding;

          //parser options
          bool instantUpdate;
          bool showEmptyNodes;
          bool showClosingTags;
          uint refreshFrequency;
          TQString defaultDocType;
          uint expandLevel;
          bool showDTDSelectDialog;
          TQString showCloseButtons; ///< can be Disabled, ShowAlways or ShowDelayed
          uint toolviewTabs; ///< how does the toolview tabs look like

         //kafka sync options
          bool quantaRefreshOnFocus;
          int quantaRefreshDelay;
          bool kafkaRefreshOnFocus;
          int kafkaRefreshDelay;

          //kafka indentation options
          bool inlineNodeIndentation;

          //environment options
          TQString globalDataDir;         //not stored, initialized on app startup
          TQStringList pluginSearchPaths; //global but read from plugins.rc
          TQString markupMimeTypes;
          TQString scriptMimeTypes;
          TQString imageMimeTypes;
          TQString textMimeTypes;
          TQString previewPosition;
          TQString docPosition;
          TQString windowLayout;
          uint autosaveInterval;
          TQString backupDirPath;
          TQString quantaPID;
          bool showHiddenFiles;  ///< show hidden files in files treeview?
          bool saveTrees;         ///< save tree status for local trees?
          TQMap<TQString, Abbreviation> abbreviations; ///< the abbreviation groups
          bool replaceAccented; ///< replace or not the accented characters
          bool replaceNotInEncoding; ///< replace characters with their entity number if they cannot be saved in the current encoding of the document.
          bool smartTagInsertion; //enable/disable smartTagInsertion
        };

struct DirInfo {
      TQString mimeType;
      TQString preText;
      TQString postText;
      bool    usePrePostText;
    };

/**Some common, mostly static functions.
  *@author Andras Mantia
  */

class QuantaCommon {
public:
  QuantaCommon();
  ~QuantaCommon();

  /** convert tag to upper or lower case */
  static TQString tagCase( const TQString& tag);
  /** convert tag to upper or lower case */
  static TQString attrCase( const TQString& attr);
/** returns the attribute value in quoted form, by taking care of the
quotation setting*/
  static TQString quoteAttributeValue(const TQString& value);
  /** Set's up the url correctly from urlString. */
  static void setUrl(KURL &url, const TQString& urlString);
  /** No descriptions */
  static bool isSingleTag(const TQString& dtdName, const TQString& tag);
  /** No descriptions */
  static bool isOptionalTag(const TQString& dtdName, const TQString& tag);
  /** No descriptions */
  static bool isKnownTag(const TQString& dtdName, const TQString& tag);
  /** No descriptions */
  static AttributeList* tagAttributes(const TQString& dtdName, const TQString& tag);
  /** Returns the TQTag object for the tag "tag" from the DTD named "dtdname". */
  static TQTag* tagFromDTD(const TQString& dtdName, const TQString& tag);
  /** Returns the TQTag object for the tag "tag" from the DTD. */
  static TQTag* tagFromDTD(const DTDStruct* dtd, const TQString& tag);
  /** Returns the TQTag object for the node "node" from node's DTD. */
  static TQTag* tagFromDTD(Node *node);
  /** Returns an XML style string containing the GUI for attributes. */
  static TQString xmlFromAttributes(AttributeList* attributes);
  /** Returns 0 if the (line,col) is inside the area specified by the other arguments,
      -1 if it is before the area and 1 if it is after. */
  static int isBetween(int line, int col, int bLine, int bCol, int eLine, int eCol);
  /** Returns a pointer to a KStandardDirs object usable for plugin searchup. type is the plugin binary type (exe or lib). The returned
pointer must be deleted by the caller!! */
  static KStandardDirs* pluginDirs(const char *type);

  /** Return true, if the url has the mimetype starting with type. */
  static bool checkMimeGroup(const KURL& url, const TQString& type);
  /** Return true, if the url has the mimetype type. */
  static bool checkMimeType(const KURL& url, const TQString& type);
  /** Return true, if the url has exactly the mimetype type. */
  static bool checkExactMimeType(const KURL& url, const TQString& type);
  /** Returns the url without the filename. */
  static KURL convertToPath(const KURL& url);
  /** Return a string to be used when an url is saved to the project file.
      Returns url.url() if it's an absolute url and
      url.path() if the url is relative */
  static TQString qUrl(const KURL& url);
  /** No descriptions */
  static void dirCreationError(TQWidget *widget, const KURL& url);
  /**
  Adds the backslash before the special chars (like ?, *, . ) so the returned string can be used in regular expressions.
  */
  static TQString makeRxCompatible(const TQString& s);
  /** Returns the translated a_str in English. A "back-translation" useful e.g in case of CSS elements selected from a listbox. */
  static TQString i18n2normal(const TQString& a_str);

/** No descriptions */
  static void normalizeStructure(TQString f,TQStringList& l);
  /**Returns true if tag2 is the closing pair of tag1. It's namespace aware.*/
  static bool closesTag(Tag *tag1, Tag *tag2);
  static bool closesTag(TQString namespaceName, TQString tagName, bool caseSensitive,
    TQString namespaceName2, TQString tagName2, bool caseSensitive2);
  static int denyBinaryInsert(TQWidget *window);
  static void removeCommentsAndQuotes(TQString& str, const DTDStruct* dtd);
  static bool insideCommentsOrQuotes(int position, const TQString &string, const DTDStruct *dtd);
  /** Calls a Quanta DCOP method.
  * @param interface the DCOP interface the method belongs to
  * @param method the DCOP method name (with the argument types)
  * @param arguments comma separated list of argument
  * @return the return value of the DCOP caller
  */
  static DCOPReply callDCOPMethod(const TQString& interface, const TQString& method, const TQString& arguments);
  /** Checks if url exists and shows a question about overwriting it.
  *  @param url the url to check
  *  @return true if the user answered yes, false otherwise.
  */
  static bool checkOverwrite(const KURL& url, TQWidget *window);

  /**
   * Same as KConfigBase::readPathListEntry, but resolves symlinks
   * @param config
   * @param pKey
   * @return
   */
  static TQStringList readPathListEntry(KConfig *config, const TQString &pKey);

    /**
   * Same as KConfigBase::readPathEntry, but resolves symlinks
   * @param config
   * @param pKey
   * @return
     */
  static TQString readPathEntry(KConfig *config, const TQString &pKey);

  /**
   * Returns the HTML encoding string for character with the specified code.
   * If no such literal encoding is known (like &auml;), the numeric encoding
   * is returned: &#code;
   * @param code the numeric code of the character
   * @return the encoded string
   */
  static TQString encodedChar(uint code);

};

#endif
