/***************************************************************************
                          dtepeditdlg.h  -  description
                             -------------------
    begin                : Tue Feb 1 11:07:24 2005
    copyright            : (C) 2005 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef DTEPEDITDLG_H
#define DTEPEDITDLG_H

//qt includes
#include <tqvaluelist.h>

//own includes
#include "dtepeditdlgs.h"

/**
@author Andras Mantia
*/

class KConfig;
class DTEPStructureEditDlgS;

struct StructGroup {
  TQString name;   ///<the name of the group
  TQString noName; ///<the text when there are no elements in the group
  TQString icon;   ///<the icon of the group
  TQString tag;
  bool hasFileName;
  TQString fileNameRx;
  bool appendToTags;
  TQString parentGroup;
  TQString definitionRx;
  bool definitionRxMinimal;
  TQString usageRx;
  TQString typeRx;
  TQString tagType;
  bool parseFile;
  TQString completeAfterRx;
  TQString removeRx;
  bool simpleGroup;
  bool variableGroup;
  bool functionGroup;
  bool classGroup;
  bool objectGroup;
};

class DTEPEditDlg : public DTEPEditDlgS
{
  Q_OBJECT
  TQ_OBJECT
  public:
    DTEPEditDlg(const TQString& descriptionFile, TQWidget *parent = 0, const char *name = 0);
    ~DTEPEditDlg();
    void saveResult();
    void slotFamilyChanged(int family);
    void slotEditStructGroup();
    void slotAddStructGroup();
    void slotDeleteStructGroup();
    
  private:  
    void init();
    void readGeneral();
    void readPages();
    void readParserRules();
    void readStructures();
    StructGroup readFromStructDlg(DTEPStructureEditDlgS *structDlg);
    
    void writeGeneral(KConfig *config);
    void writePages(KConfig *config);
    void writeParserRules(KConfig *config);
    void writeStructures(KConfig *config);
    void writeEntry(KConfig *config, const TQString &key, const TQString &value);
    
  TQString m_descriptionFile;
  KConfig *m_config;
  int m_family;
  TQWidget *m_pagesWidget;
  TQValueList<StructGroup> m_structGroups;
};

#endif
