/***************************************************************************
                          tableitem.h  -  description
                             -------------------
    begin                : Mon 15 Mar 2004
    copyright            : (C) 2004 by Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABLEITEM_H
#define TABLEITEM_H

#include <tqtable.h>
#include <kdeversion.h>

class TableItem : public TQTableItem
{
private:
  TQt::AlignmentFlags m_halign;
  TQt::AlignmentFlags m_valign;
  bool m_header;
public:
  // Standard constructors copied from TQTableItem
  TableItem(TQTable* table, EditType et);
  TableItem(TQTable* table, EditType et, const TQString& text);
  TableItem (TQTable* table, EditType et, const TQString& text, const TQPixmap& p);
  // Use TQTextEdit instead of standard TQLineEdit
  virtual TQWidget* createEditor() const;
  // Get text from TQTextEdit
  virtual void setContentFromEditor(TQWidget *w);
  // Paint cell - handle alignment (horizontal and vertical) and bold for header
  virtual void paint(TQPainter* p, const TQColorGroup& cg, const TQRect& cr, bool selected);
  // Return A bit larger sizeHint because TQTextEdit has some margin around
  virtual TQSize sizeHint() const;
  // Get and set vertical aligment
  TQt::AlignmentFlags vAlignment()	{return m_valign;}
  void setVAlignment(TQt::AlignmentFlags flags)	{m_valign = flags;}
  // Get and set horizontal aligment
  TQt::AlignmentFlags alignment()	{return m_halign;}
  void setAlignment(TQt::AlignmentFlags flags)	{m_halign = flags;}
  // Get and set header status (use true for TH, false for TD)
  bool header()	{return m_header;}
  void setHeader(bool h)  {m_header = h;}
};



#endif

