/***************************************************************************
                            debuggerinterface.h
                            -------------------
    begin                : 2004-03-12
    copyright            : (C) 2004 Linus McCabe <linus@mccabe.nu>

 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/

#ifndef DEBUGGERINTERFACE_H
#define DEBUGGERINTERFACE_H

#include <tqobject.h>
#include <tqstring.h>
#include <kurl.h>

#include "debuggervariable.h"
#include "debuggerbreakpoint.h"
#include "backtracelistview.h"

class PathMapper;

class DebuggerInterface : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

  private:


  public:
    DebuggerInterface(TQObject *parent, const char* name);

    // Breakpoints
    virtual void haveBreakpoint (const TQString& file, int line) = 0;
    virtual void havenoBreakpoint (const TQString& file, int line) = 0;

    // Public help functions
    virtual bool showStatus(const TQString& message, bool log) = 0;
    virtual bool setActiveLine (const TQString& file, int line) = 0;

    virtual void enableAction(const TQString& action, bool enable) = 0;
    virtual void fileOpened(const TQString& file) = 0;
    virtual void sendRequest(const KURL &url) = 0;
    virtual const TQString activeFileParts(const TQString & str) = 0;

    // Watch handling
    //virtual void preWatchUpdate() = 0;
    //virtual void postWatchUpdate() = 0;

    virtual DebuggerVariable* newDebuggerVariable(const TQString& name, const TQString& value, int type) = 0;
    virtual DebuggerVariable* newDebuggerVariable(const TQString& name, const ValueList_t& values, int type) = 0;
    virtual void showVariable(DebuggerVariable*) = 0;

    // Backtrace
    virtual void backtraceClear() = 0;
    virtual void backtraceShow(long level, BacktraceType type, const TQString &filename, long line, const TQString& func) = 0;

    
    // Breakpoints
    virtual void showBreakpoint(const DebuggerBreakpoint &bp) = 0;
    virtual void refreshBreakpoints() = 0;
    virtual DebuggerBreakpoint * newDebuggerBreakpoint() = 0;
    virtual DebuggerBreakpoint * findDebuggerBreakpoint(const TQString& key) = 0;
    virtual void updateBreakpointKey(const DebuggerBreakpoint &bp, const TQString& newkey) = 0;

    // Path mapping
    virtual PathMapper* Mapper() = 0;
};

#endif


