#ifndef KXSLDBGKPART_H
#define KXSLDBGKPART_H

#include <kparts/part.h>
#include <tqvariant.h>
#include <tqdict.h>
#include <tqmainwindow.h>
#include "xsldbgdebugger.h"
#include "xsldbginspector.h"
#include <dcopclient.h>
#include "kxsldbg_partif.h"
#include <ktexteditor/document.h> 
#include <ktexteditor/view.h> 

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQAction;
class TQActionGroup;
class TQToolBar;
class TQPopupMenu;
class TQTextBrowser;
class TQLineEdit;
class TQDockWindow;
class TQWidgetStack;

class XsldbgBrkStatusView;
class QXsldbgDoc;
class XsldbgOutputView;
class XsldbgConfigImpl;

class TQWidget;
class TQPainter;
class KURL;
class TQMultiLineEdit;
class KAboutData;

typedef TQDict<QXsldbgDoc> XsldbgDocDict;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Keith Isdale <k_isdale@tpg.com.au>
 * @version 0.1
 */
class KXsldbgPart : public KParts::ReadOnlyPart, public KXsldbgPartIf 
{
    Q_OBJECT
  TQ_OBJECT

public:
    /**
     * Default constructor
     */
    KXsldbgPart(TQWidget *parentWidget, const char *widgetName,
                    TQObject *parent, const char *name, const TQStringList &args);

    /**
     * Destructor
     */
    virtual ~KXsldbgPart();

    static KAboutData *createAboutData();


   /** Checks the debugger, if it is not ready then
     *      display a error in a message box
     *
     * @returns TRUE if debugger is ready, otherwise FALSE
     */
    bool checkDebugger();
    void lookupSystemID(TQString systemID);
    void lookupPublicID(TQString publicID);
    void createInspector();

public slots:
    virtual bool openURL(const KURL &url);
    virtual bool closeURL();
    void quit();
    void emitOpenFile(TQString file, int line, int row);
    void slotLookupSystemID();
    void slotLookupPublicID();
    void walkCmd_activated();
    void walkStopCmd_activated();
    void traceCmd_activated();
    void traceStopCmd_activated();
    void configureEditorCmd_activated(); 

  //Tool bar commands
    void configureCmd_activated();
    void inspectorCmd_activated();
    void runCmd_activated();
    void stepCmd_activated();
    void nextCmd_activated();
    void continueCmd_activated();
    void stepupCmd_activated();
    void stepdownCmd_activated();
    void sourceCmd_activated();
    void dataCmd_activated();
    void outputCmd_activated();
    void refreshCmd_activated();
    void enableCmd_activated();
    void breakCmd_activated();
    void deleteCmd_activated();

    /** Evaluate expression entered */	
    void evaluateCmd_activated();

    /** Goto/display file XPath entered */
    void gotoXPathCmd_activated();

    virtual void lineNoChanged( TQString fileName, int lineNumber,
				bool breakpoint );

    void addBreakPoint(int lineNumber);
    void enableBreakPoint(int lineNumber);
    void deleteBreakPoint(int lineNumber);

    /** Evaluate expression entered in expressionEdit */
    void slotEvaluate();

    /** Goto/display file that matches XPath specified in xPathEdit */
    void slotGotoXPath();

     /** Run search on data base , see search.dtd for DTD of search database */
    void slotSearch();

    /* Process the the URI for SystemID or PublicID requested */
    void slotProcResolveItem(TQString URI);

    /* used to get breakpoint list notfication */
    void breakpointItem(TQString fileName, int  lineNumber ,
			TQString /*templateName*/, TQString /* modeName */,
			bool  enabled , int /* id */);

    void cursorPositionChanged();
    void docChanged();
    
    void debuggerStarted();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();
    bool fetchURL(const KURL &url);

protected slots:
    void fileOpen();

private:
    QXsldbgDoc *currentDoc;
    TQWidgetStack *mainView;

    TQPushButton *xPathBtn, *searchBtn, *evaluateBtn;
    TQLineEdit *newXPath, *newSearch, *newEvaluate;
    TQGridLayout* qxsldbgLayout;

    uint currentLineNo, currentColumnNo;
    XsldbgDocDict docDictionary;
    XsldbgInspector *inspector;
    XsldbgDebugger *debugger;
    XsldbgConfigImpl *configWidget;
    TQString currentFileName;

    XsldbgOutputView *outputview;
};

#endif // KXSLDBGPART_H
