/***************************************************************************
 *   Copyright (C) 2003 by KDevelop Authors                                *
 *   www.kdevelop.org                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CVSPROCESSWIDGET_H_
#define _CVSPROCESSWIDGET_H_

#include <tqtextedit.h>
#include <tqstringlist.h>

#include "cvsservicedcopIface.h"
#include "bufferedstringreader.h"

class CvsServicePart;
class DCOPRef;
class CvsJob_stub;
class CvsService_stub;
class TQStyleSheetItem;

class CvsProcessWidget : public TQTextEdit, virtual public CVSServiceDCOPIface
{
    Q_OBJECT
  TQ_OBJECT
public:
    CvsProcessWidget( CvsService_stub *service, CvsServicePart *part,
        TQWidget *parent, const char *name );
    virtual ~CvsProcessWidget();

    bool startJob( const DCOPRef &aJob );

    /**
    * @return true if there is already a job pending, false otherwise
    * (another job can be requested)
    */
    bool isAlreadyWorking() const;
    void cancelJob();

    virtual void clear();

    TQStringList output() const { return m_output; }
    TQStringList errors() const { return m_errors; }

//private slots:
    //! DCOP Iface
    virtual void slotJobExited( bool normalExit, int exitStatus );
    virtual void slotReceivedOutput( TQString someOutput );
    virtual void slotReceivedErrors( TQString someErrors );

signals:
    void jobFinished( bool normalExit, int exitStatus );

private:
    void showInfo( const TQStringList &msg );
    void showError( const TQStringList &msg  );
    void showOutput( const TQStringList &msg  );

    CvsServicePart *m_part;
    CvsService_stub *m_service;
    CvsJob_stub *m_job;

    //! Buffered reader for safely reading stdout and stderr from cvs
    //! commands' output
    BufferedStringReader m_outputBuffer,
        m_errorBuffer;

    TQStringList m_output,
        m_errors;
};

#endif

