#include "tipofday_part.h"

#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqwhatsthis.h>

#include <kaboutdata.h>
#include <kaction.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kdevgenericfactory.h>
#include <kdevplugininfo.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <ktextbrowser.h>
#include <ktip.h>

#include "kdevapi.h"
#include "kdevcore.h"

static const KDevPluginInfo data("kdevtipofday");

typedef KDevGenericFactory<TipOfDayPart> TipOfDayFactory;
K_EXPORT_COMPONENT_FACTORY( libkdevtipofday, TipOfDayFactory( data ) )

TipOfDayPart::TipOfDayPart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin(&data, parent, name ? name : "TipOfDayPart")
{
  setInstance(TipOfDayFactory::instance());

  setXMLFile("kdevpart_tipofday.rc");

  KAction *action;

  action = new KAction(i18n("&Tip of the Day"), "idea", 0,
                       this, TQT_SLOT(showTip()), actionCollection(), "help_tipofday");
  action->setToolTip(i18n("A tip how to use KDevelop"));
  action->setWhatsThis(i18n("<b>Tip of the day</b><p>"
                            "Will display another good tip \n"
                            "contributed by KDevelop users."));

  connect(core(), TQT_SIGNAL(coreInitialized()), this, TQT_SLOT(showOnStart()));
}


TQString TipOfDayPart::getFilename()
{
  KConfig * config = KApplication::kApplication()->config();
  config->setGroup("Tip of day plugin");
  return config->readEntry("TipsFile", "kdevtipofday/tips");
}

void TipOfDayPart::showTip()
{
  KTipDialog::showTip(getFilename(), true);
}


void TipOfDayPart::showOnStart()
{
  KTipDialog::showTip(getFilename());
}



#include "tipofday_part.moc"
