#ifndef __ASTYLE_ADAPTOR_H__
#define __ASTYLE_ADAPTOR_H__


#include <tqstring.h>
#include <tqtextstream.h>
#include <tqmap.h>
#include <tqvariant.h>

#include "astyle.h"

#define GLOBALDOC_OPTIONS 1
#define PROJECTDOC_OPTIONS 2


class ASStringIterator : public astyle::ASSourceIterator
{
public:

  ASStringIterator(const TQString &string);
  virtual ~ASStringIterator();

  virtual bool hasMoreLines() const;
  virtual string nextLine();


private:

  TQString _content;
  TQTextStream *_is;

};

class AStyleWidget;

class KDevFormatter : public astyle::ASFormatter
{
public:

  KDevFormatter(const TQMap<TQString, TQVariant>& options);
  KDevFormatter( AStyleWidget * widget );
  TQString indentString() const
  {
	  return m_indentString;
  }
  
private:
	bool predefinedStyle( const TQString & style );

private:
	TQString m_indentString;
};


#endif
