/***************************************************************************
 *   Copyright (C) 2003 by Harald Fernengel                                *
 *   harry@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _SQLOUTPUTWIDGET_H_
#define _SQLOUTPUTWIDGET_H_

#include <tqwidget.h>

class TQWidgetStack;
class TQDataTable;
class TQTextEdit;
class TQSqlError;

class SqlOutputWidget : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    SqlOutputWidget( TQWidget* parent = 0, const char* name = 0 );
    virtual ~SqlOutputWidget();

public:
    void showQuery( const TQString& connectionName, const TQString& query );
    void showError( const TQSqlError& error );

private:
    void showError( const TQString& msg );
    void showSuccess( int rowsAffected );

    TQWidgetStack* m_stack;
    TQDataTable* m_table;
    TQTextEdit* m_textEdit;
};

#endif
