/*
   Copyright (C) 2005 by Nicolas Escuder <n.escuder@intra-links.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   version 2, License as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PHPFILE_H
#define PHPFILE_H

#include <kapplication.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqfileinfo.h>
#include <tqregexp.h>
#include <tqthread.h>

#include <urlutil.h>
#include <kprocess.h>
#include <kdebug.h>

#include <kdevproject.h>
#include <kdevlanguagesupport.h>
#include <kdevpartcontroller.h>

#include <ktexteditor/editinterface.h>
#include <ktexteditor/document.h>

#include "phpsupportpart.h"
#include "phperrorview.h"
#include "phpparser.h"
#include "phpsupport_event.h"

/**
@author Escuder Nicolas
*/
class PHPFile : public TQObject {
Q_OBJECT
  TQ_OBJECT

public:
   PHPFile(PHPSupportPart *phpSupport, const TQString& fileName);
   ~PHPFile();

   TQStringList getContents();

   bool isModified();
   void setModified(bool value);
   TQString fileName();
   void Analyse();
   void ParseStdout(TQString phpOutput);
/*
   ClassDom classByName(TQString filename, TQString classname);
   TQValueList<ClassDom> classByName(TQString classname);
*/

/*
private slots:
    void slotReceivedPHPCheckStderr (KProcess* proc, char* buffer, int buflen);
    void slotReceivedPHPCheckStdout (KProcess* proc, char* buffer, int buflen);
    void slotPHPCheckExited (KProcess* proc);
*/
private:
   TQStringList readFromEditor();
   TQStringList readFromDisk();

   bool ParseClass(TQString line, int lineNo);
   bool ParseFunction(TQString line, int lineNo);
   bool ParseVariable(TQString line, int lineNo);

   bool ParseThisMember(TQString line, int lineNo);
   bool ParseMember(TQString line, int lineNo);
   bool ParseReturn(TQString line, int lineNo);
   bool ParseTodo(TQString line, int lineNo);
   bool ParseFixme(TQString line, int lineNo);

   void ParseSource();
   void PHPCheck();

   void postEvent(FileParseEvent *event);

   bool AddClass(TQString name, TQString extends, int start);
   bool SetClass(TQString arguments);
   bool CloseClass(int end);

   bool AddFunction(TQString name, TQString arguments, int start);
   bool SetFunction(TQString name, TQString arguments = "");
   bool CloseFunction(int end);

   bool AddVariable(TQString name, TQString type, int position, bool classvar = FALSE);
   bool SetVariable(TQString arguments);

   bool AddTodo(TQString arguments, int position);
   bool AddFixme(TQString arguments, int position);

   PHPSupportPart *m_part;

   bool modified;

   bool inClass;
   bool inMethod;

   TQFileInfo* m_fileinfo;
   TQStringList m_contents;
   TQString m_phpCheckOutput;
//   KShellProcess* phpCheckProc;
};

#endif
