/***************************************************************************
 *   Copyright (C) 2003 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDEVTQTIMPORTER_H
#define KDEVTQTIMPORTER_H

#include <kdevpcsimporter.h>
#include <tqguardedptr.h>

class SettingsDialog;

class KDevKDELibsImporter : public KDevPCSImporter
{
    Q_OBJECT
  TQ_OBJECT
public:
    KDevKDELibsImporter( TQObject* parent=0, const char* name=0, const TQStringList& args=TQStringList() );
    virtual ~KDevKDELibsImporter();

    virtual TQString dbName() const { return TQString::fromLatin1("KDElibs"); }
    virtual TQStringList fileList();
    virtual TQStringList includePaths();

    virtual TQWidget* createSettingsPage( TQWidget* parent, const char* name=0 );

private:
    TQStringList fileList( const TQString& path );

private:
    TQGuardedPtr<SettingsDialog> m_settings;
};

#endif
