/***************************************************************************
    begin                : Tue Oct 5 1999
    copyright            : (C) 1999 by John Birch
    email                : jbb@kdevelop.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _MEMVIEW_H_
#define _MEMVIEW_H_

#include "mi/gdbmi.h"

#include <kdialog.h>

#include <tqvaluevector.h>

class KLineEdit;
class TQMultiLineEdit;
class TQToolBox;

namespace GDBDebugger
{
    class MemoryView;
    class GDBController;

    class ViewerWidget : public TQWidget
    {
        Q_OBJECT
  TQ_OBJECT
    public:
        ViewerWidget(GDBController* controller,
                     TQWidget* parent, const char* name);

    public slots:
        /** Adds a new memory view to *this, initially showing
            no data. */
        void slotAddMemoryView();
        /** Informs *this about change in debugger state. Should always
            be connected to, so that *this can disable itself when
            debugger is not running. */
        void slotDebuggerState(const TQString&, int state);

    signals:
        void setViewShown(bool shown);


    private slots:
        void slotChildCaptionChanged(const TQString& caption);
        void slotChildDestroyed(TQObject* child);
     
    private: // Data
        GDBController* controller_;
        TQToolBox* toolBox_;
        TQValueVector<MemoryView*> memoryViews_;
    };

    class MemoryView : public TQWidget
    {
        Q_OBJECT
  TQ_OBJECT
    public:
        MemoryView(GDBController* controller, 
                   TQWidget* parent, const char* name = 0);

        void debuggerStateChanged(int state);

    signals:
        void captionChanged(const TQString& caption);

    private: // Callbacks
        void sizeComputed(const TQString& value);

        void memoryRead(const GDBMI::ResultRecord& r);

    private slots:
        void memoryEdited(int start, int end);

    private:        
        // Returns true is we successfully created the hexeditor, and so
        // can work.
        bool isOk() const;

        

    private slots:
        /** Invoked when user has changed memory range.
            Gets memory for the new range. */
        void slotChangeMemoryRange();
        void slotHideRangeDialog();
        void slotEnableOrDisable();

    private: // TQWidget overrides
        void contextMenuEvent(TQContextMenuEvent* e);

    private:
        void initWidget();

    private:
        GDBController* controller_;
        class MemoryRangeSelector* rangeSelector_;
        TQWidget* khexedit2_widget;
        TQWidget* khexedit2_real_widget;

        uint start_, amount_;
        TQString startAsString_, amountAsString_;
        char* data_;
        
        int debuggerState_;
    };
}

#endif
