/***************************************************************************
    begin                : Sun Aug 8 1999
    copyright            : (C) 1999 by John Birch
    email                : jbb@kdevelop.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DISASSEMBLEWIDGET_H_
#define _DISASSEMBLEWIDGET_H_

#include "mi/gdbmi.h"

#include <tqtextedit.h>

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

namespace GDBDebugger
{

class Breakpoint;
class GDBController;

class DisassembleWidget : public TQTextEdit
{
    Q_OBJECT
  TQ_OBJECT

public:
    DisassembleWidget( GDBController* controller, TQWidget *parent=0, const char *name=0 );
    virtual ~DisassembleWidget();

public slots:
    void slotActivate(bool activate);
    void slotShowStepInSource(const TQString &fileName, int lineNum, const TQString &address);

private:
    virtual void showEvent(TQShowEvent*);
    virtual void hideEvent(TQHideEvent*);

    bool displayCurrent();
    void getNextDisplay();

    /// callback for GDBCommand
    void memoryRead(const GDBMI::ResultRecord& r);

    GDBController* controller_;
    bool    active_;
    unsigned long    lower_;
    unsigned long    upper_;
    unsigned long    address_;
    TQString currentAddress_;
};

}

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

#endif
