/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addprefixdlg.h"

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <kbuttonbox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kstdguiitem.h>
#include <kdeversion.h>

AddPrefixDialog::AddPrefixDialog( const TQString& nameEdit, const TQString& pathEdit,
        TQWidget *parent, const char *name)
    : TQDialog(parent, name, true)
{
    setCaption(i18n("Add Prefix"));

    TQLabel *name_label = new TQLabel(i18n("&Name:"), this);
    name_edit = new KLineEdit(nameEdit, this);
    name_edit->setFocus();
    name_label->setBuddy(name_edit);
    connect( name_edit, TQT_SIGNAL( textChanged ( const TQString & ) ), TQT_SLOT( slotPrefixChanged() ) );

    TQLabel *path_label = new TQLabel(i18n("&Path:"), this);
    path_edit = new KLineEdit(pathEdit, this);
    path_label->setBuddy(path_edit);
    TQFontMetrics fm(path_edit->fontMetrics());
    path_edit->setMinimumWidth(fm.width('X')*35);
    connect( path_edit, TQT_SIGNAL( textChanged ( const TQString & ) ), TQT_SLOT( slotPrefixChanged() ) );

    TQVBoxLayout *layout = new TQVBoxLayout(this, 10);

    TQGridLayout *grid = new TQGridLayout(2, 2);
    layout->addLayout(grid);
    grid->addWidget(name_label, 0, 0);
    grid->addWidget(name_edit, 0, 1);
    grid->addWidget(path_label, 1, 0);
    grid->addWidget(path_edit, 1, 1);

    TQFrame *frame = new TQFrame(this);
    frame->setFrameStyle(TQFrame::HLine | TQFrame::Sunken);
    layout->addWidget(frame, 0);

    KButtonBox *buttonbox = new KButtonBox(this);
    buttonbox->addStretch();
    m_pOk = buttonbox->addButton(KStdGuiItem::ok());
    TQPushButton *cancel = buttonbox->addButton(KStdGuiItem::cancel());
    m_pOk->setDefault(true);
    connect( m_pOk, TQT_SIGNAL(clicked()), this, TQT_SLOT(accept()) );
    connect( cancel, TQT_SIGNAL(clicked()), this, TQT_SLOT(reject()) );
    buttonbox->layout();
    layout->addWidget(buttonbox, 0);
    slotPrefixChanged();
}


AddPrefixDialog::~AddPrefixDialog()
{}

void AddPrefixDialog::slotPrefixChanged()
{
    m_pOk->setEnabled( !name_edit->text().isEmpty() && !path_edit->text().isEmpty() );
}

#include "addprefixdlg.moc"
