/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef SVNLOGDLGIMP_H
#define SVNLOGDLGIMP_H

#include "svnlogdlg.h"
#include "simple_logcb.h"
#include "src/svnqt/log_entry.hpp"
#include "src/svnqt/client.hpp"
#include "src/svnqt/shared_pointer.hpp"

#include <tqsize.h>
#include <tqregexp.h>

class LogListViewItem;
class SvnActions;

class SvnLogDlgImp: public SvnLogDialogData,public SimpleLogCb
{
Q_OBJECT
  TQ_OBJECT
public:
    SvnLogDlgImp(SvnActions*,TQWidget *parent = 0, const char *name = 0,bool modal=true);
    virtual ~SvnLogDlgImp();
    void dispLog(const svn::SharedPointer<svn::LogEntriesMap>&,const TQString&,const TQString&,const svn::Revision&peg,const TQString&pegUrl);
    void saveSize();
    TQSize dialogSize();

    virtual bool getSingleLog(svn::LogEntry&t,const svn::Revision&r,const TQString&what,const svn::Revision&peg,TQString&root);

signals:
    void makeDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);
    void makeCat(const svn::Revision&,const TQString&,const TQString&,const svn::Revision&,TQWidget*);

protected slots:
    virtual void slotSelectionChanged(TQListViewItem*);
protected slots:
    virtual void slotDispPrevious();
    virtual void slotDispSelected();
    virtual void slotItemClicked(int,TQListViewItem*,const TQPoint &,int);
    virtual void slotRevisionSelected();
protected:
    TQString _name;
    TQString _base;
    static const char* groupName;
    LogListViewItem *m_first,*m_second;
    SvnActions*m_Actions;
    bool m_ControlKeyDown;
    virtual void keyPressEvent (TQKeyEvent * e);
    virtual void keyReleaseEvent (TQKeyEvent * e);
    virtual void slotBlameItem();
    svn::SharedPointer<svn::LogEntriesMap> m_Entries;
    TQString _bugurl;

    void dispLog(const svn::SharedPointer<svn::LogEntriesMap>&);

    TQRegExp _r1,_r2;

protected slots:
    virtual void slotListEntries();
    virtual void slotEntriesSelectionChanged();
    virtual void slotSingleContext(TQListViewItem*, const TQPoint &, int);
    virtual void slotSingleDoubleClicked(TQListViewItem*);
    virtual void slotGetLogs();

protected:
    void replaceBugids(TQString&msg);
    TQString genReplace(const TQString&);
    svn::Revision m_peg;
    svn::Path m_PegUrl;
};

#endif
