/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include "pwstorage.h"
#include "kdesvn-config.h"
#include "src/settings/kdesvnsettings.h"

#include <kwallet.h>
#include <kwin.h>
#include <kapp.h>

#include <tqthread.h>
#include <tqmap.h>
#include <tqpair.h>

class PwStorageData
{
public:

    PwStorageData(){
        m_Wallet=0;
    }

    ~PwStorageData()
    {
        delete m_Wallet;
        m_Wallet=0;
    }

    KWallet::Wallet*getWallet();

    typedef TQPair<TQString,TQString> userpw_type;
    typedef TQMap<TQString, userpw_type> cache_type;

    cache_type*getLoginCache();

    TQMutex*getCacheMutex();

protected:
    KWallet::Wallet* m_Wallet;

};

TQMutex*PwStorageData::getCacheMutex()
{
    static TQMutex _mutex;
    return &_mutex;
}

PwStorageData::cache_type*PwStorageData::getLoginCache()
{
    static PwStorageData::cache_type _LoginCache;
    return &_LoginCache;
}

KWallet::Wallet*PwStorageData::getWallet()
{
    static bool walletOpenFailed = false;
    if (m_Wallet && m_Wallet->isOpen()) {
        return m_Wallet;
    }

    if (KWallet::Wallet::isEnabled()) {
        WId window = 0;
        if ( tqApp->activeWindow() ) {
            window = tqApp->activeWindow()->winId();
        }
        delete m_Wallet;
        m_Wallet = KWallet::Wallet::openWallet( KWallet::Wallet::NetworkWallet(),window);
    }
    if (!m_Wallet) {
        walletOpenFailed = true;
    } else {
        if (!m_Wallet->hasFolder(WALLETNAME)) {
            m_Wallet->createFolder(WALLETNAME);
        }
        m_Wallet->setFolder(WALLETNAME);
    }
    return m_Wallet;
}

PwStorage*PwStorage::self()
{
    static PwStorage*_me = 0;
    if (!_me) {
        _me = new PwStorage();
    }
    return _me;
}

/*!
    \fn PwStorage::PwStorageData()
 */
PwStorage::PwStorage()
    :TQObject()
{
    mData = new PwStorageData;
}

/*!
    \fn PwStorage::~PwStorageData()
 */
PwStorage::~PwStorage()
{
    delete mData;
}


/*!
    \fn PwStorage::connectWallet()
 */
bool PwStorage::connectWallet()
{
    return mData->getWallet()!=0L;
}

/*!
    \fn PwStorage::getCertPw(const TQString&realm,TQString&pw)
 */
bool PwStorage::getCertPw(const TQString&realm,TQString&pw)
{
    if (!mData->getWallet()) {
        return false;
    }
    return (mData->getWallet()->readPassword(realm,pw)==0);
}


/*!
    \fn PwStorage::getLogin(const TQString&realm,TQString&user,TQString&pw)
 */
bool PwStorage::getLogin(const TQString&realm,TQString&user,TQString&pw)
{
    if (!mData->getWallet()) {
        return false;
    }
    TQMap<TQString,TQString> content;
    int j = mData->getWallet()->readMap(realm,content);
    if (j!=0||content.find("user")==content.end()) {
        return true;
    }
    user = content["user"];
    pw = content["password"];
    return true;
}

bool PwStorage::getCachedLogin(const TQString&realm,TQString&user,TQString&pw)
{
    TQMutexLocker lc(mData->getCacheMutex());
    PwStorageData::cache_type::ConstIterator it = mData->getLoginCache()->find(realm);
    if (it!=mData->getLoginCache()->end()) {
        user=(*it).first;
        pw = (*it).second;
    }
    return true;
}

/*!
    \fn PwStorage::setCertPw(const TQString&realm, const TQString&pw)
 */
bool PwStorage::setCertPw(const TQString&realm, const TQString&pw)
{
    if (!mData->getWallet()) {
        return false;
    }
    return (mData->getWallet()->writePassword(realm,pw)==0);
}


/*!
    \fn PwStorage::setLogin(const TQString&realm,const TQString&user,const TQString&pw)
 */
bool PwStorage::setLogin(const TQString&realm,const TQString&user,const TQString&pw)
{
    if (!mData->getWallet()) {
        return false;
    }
    TQMap<TQString,TQString> content;
    content["user"]=user;
    content["password"]=pw;
    return (mData->getWallet()->writeMap(realm,content)==0);
}

bool PwStorage::setCachedLogin(const TQString&realm,const TQString&user,const TQString&pw)
{
    TQMutexLocker lc(mData->getCacheMutex());
    PwStorageData::cache_type*_Cache = mData->getLoginCache();
    (*_Cache)[realm]=PwStorageData::userpw_type(user,pw);
    return true;
}

#include "pwstorage.moc"
