/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2002-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "notedialog.h"

// qt/kde includes
#include <tqlineedit.h>
#include <tqgroupbox.h>
#include <tqtextedit.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <klocale.h>
#include <kmessagebox.h>


NoteDialog::NoteDialog( TQWidget * parent, NoteWidget * pNote ) : KDialogBase(Plain, i18n("Note Documentation"), Help | Ok | Cancel , Ok, parent, "_NOTEDIALOG_", true, true) {
    m_pNoteWidget = pNote;
    int margin = fontMetrics().height();

    m_pDocGB = new TQGroupBox(i18n("Documentation"), plainPage());
    TQVBoxLayout * mainLayout = new TQVBoxLayout(plainPage());
    mainLayout -> addWidget(m_pDocGB);
    mainLayout -> setSpacing(10);
    mainLayout -> setMargin(margin);

    TQHBoxLayout * docLayout = new TQHBoxLayout(m_pDocGB);
    docLayout -> setSpacing(10);
    docLayout -> setMargin(margin);

    m_pDocTE = new TQTextEdit( m_pDocGB );
    m_pDocTE -> setFocus();
    docLayout -> addWidget( m_pDocTE );
    m_pDocTE -> setText( pNote -> getDoc() );
    setMinimumSize(330, 160);
}

NoteDialog::~NoteDialog() {}

void NoteDialog::slotOk() {
    m_pNoteWidget -> setDoc( m_pDocTE -> text() );
    accept();
}

#include "notedialog.moc"
