/*
    This file is part of KOrganizer.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KOJOURNALVIEW_H
#define KOJOURNALVIEW_H

#include <korganizer/baseview.h>

class JournalDateEntry;
class JournalEntry;
class TQScrollView;
class TQVBox;

/**
 * This class provides a journal view.

 * @short View for Journal components.
 * @author Cornelius Schumacher <schumacher@kde.org>, Reinhold Kainhofer <reinhold@kainhofer.com>
 * @see KOBaseView
 */
class KOJournalView : public KOrg::BaseView
{
    Q_OBJECT
  TQ_OBJECT
  public:
    KOJournalView( Calendar *calendar, TQWidget *parent = 0,
                   const char *name = 0);
    ~KOJournalView();

    virtual int currentDateCount();
    virtual Incidence::List selectedIncidences();
    DateList selectedIncidenceDates() { return DateList(); }
    void appendJournal( Journal*journal, const TQDate &dt);

    CalPrinterBase::PrintType printType();

  public slots:
    // Don't update the view when midnight passed, otherwise we'll have data loss (bug 79145)
    virtual void dayPassed( const TQDate & ) {}
    void updateView();
    void flushView();

    void showDates( const TQDate &start, const TQDate &end );
    void showIncidences( const Incidence::List &incidenceList, const TQDate &date );

    void changeIncidenceDisplay( Incidence *, int );
    void setIncidenceChanger( IncidenceChangerBase *changer );
    void newJournal();
  signals:
    void flushEntries();
    void setIncidenceChangerSignal( IncidenceChangerBase * );
    void journalEdited( Journal* );
    void journalDeleted( Journal* );

  protected:
    void clearEntries();

  private:
    TQScrollView *mSV;
    TQVBox *mVBox;
    TQMap<TQDate, JournalDateEntry*> mEntries;
//    DateList mSelectedDates;  // List of dates to be displayed
};

#endif
