/*
    This file is part of KOrganizer.

    Copyright (c) 2001,2003 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KOCORE_H
#define KOCORE_H

#include <calendar/calendardecoration.h>
#include <korganizer/part.h>
#include <korganizer/printplugin.h>

#include <kdepimmacros.h>
#include <ktrader.h>

namespace KPIM { class IdentityManager; }

class KDE_EXPORT KOCore
{
  public:
    ~KOCore();

    static KOCore *self();

    KTrader::OfferList availablePlugins();
    KTrader::OfferList availableCalendarDecorations();
    KTrader::OfferList availableParts();
    KTrader::OfferList availablePrintPlugins();

    KOrg::Plugin *loadPlugin( KService::Ptr service );
    KOrg::Plugin *loadPlugin( const TQString & );

    KOrg::CalendarDecoration *loadCalendarDecoration( KService::Ptr service );
    KOrg::CalendarDecoration *loadCalendarDecoration( const TQString & );

    KOrg::Part *loadPart( KService::Ptr, KOrg::MainWindow *parent );
    KOrg::Part *loadPart( const TQString &, KOrg::MainWindow *parent );
    
    KOrg::PrintPlugin *loadPrintPlugin( KService::Ptr service );
    KOrg::PrintPlugin *loadPrintPlugin( const TQString & );

    KOrg::CalendarDecoration::List calendarDecorations();
    KOrg::PrintPlugin::List loadPrintPlugins();
    KOrg::Part::List loadParts( KOrg::MainWindow *parent );

    void addXMLGUIClient( TQWidget*, KXMLGUIClient *guiclient );
    void removeXMLGUIClient( TQWidget* );
    KXMLGUIClient *xmlguiClient( TQWidget* ) const;

    /**
      Unload the parts in &p parts for this main window. Clears
      parts.
    */
    void unloadParts( KOrg::MainWindow *parent, KOrg::Part::List &parts );
    void unloadPlugins();

    void reloadPlugins();

    /**
      Unloads the parts from the main window. Loads the parts that
      are listed in KOPrefs and returns a list of these parts.
    */
    KOrg::Part::List reloadParts( KOrg::MainWindow *parent,
                                  KOrg::Part::List &parts );

    KPIM::IdentityManager* identityManager();

  protected:
    KOCore();

    KTrader::OfferList availablePlugins( const TQString &type,
                                         int pluginInterfaceVersion = -1 );

  private:
    static KOCore *mSelf;

    KOrg::CalendarDecoration::List mCalendarDecorations;
    bool mCalendarDecorationsLoaded;

    TQMap<TQWidget*, KXMLGUIClient*> mXMLGUIClients;

    KPIM::IdentityManager *mIdentityManager;
};

#endif
