/*  -*- mode: C++; c-file-style: "gnu" -*-
    regexplineedit.h

    This file is part of KMail, the KDE mail client.
    Copyright (c) 2004 Ingo Kloecker <kloecker@kde.org>

    KMail is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KMail is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef __KMAIL_REGEXPLINEEDIT_H__
#define __KMAIL_REGEXPLINEEDIT_H__

#include <tqobject.h>
#include <tqwidget.h>

class KLineEdit;

class TQString;
class TQPushButton;
class TQDialog;

namespace KMail {

  class RegExpLineEdit : public TQWidget
  {
    Q_OBJECT
  TQ_OBJECT

  public:
    RegExpLineEdit( const TQString &str, TQWidget *parent = 0,
                    const char *name = 0 );
    RegExpLineEdit( TQWidget *parent = 0, const char *name = 0 );

    TQString text() const;

  public slots:
    void clear();
    void setText( const TQString & );
    void showEditButton( bool );

  signals:
    void textChanged( const TQString & );

  protected slots:
    void slotEditRegExp();

  private:
    void initWidget( const TQString & = TQString() );

    KLineEdit * mLineEdit;
    TQPushButton * mRegExpEditButton;
    TQDialog * mRegExpEditDialog;
  };

} // namespace KMail

#endif // __KMAIL_REGEXPLINEEDIT_H__
