/*
 *  emailidcombo.h  -  email identity combo box with read-only option
 *  Program:  kalarm
 *  Copyright © 2004,2006 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef EMAILIDCOMBO_H
#define EMAILIDCOMBO_H

#include <libkpimidentities/identitycombo.h>
#include "combobox.h"


class EmailIdCombo : public KPIM::IdentityCombo
{
		Q_OBJECT
  TQ_OBJECT
	public:
		explicit EmailIdCombo(KPIM::IdentityManager*, TQWidget* parent = 0, const char* name = 0);
		void  setReadOnly(bool ro)    { mReadOnly = ro; }
	protected:
		virtual void mousePressEvent(TQMouseEvent*);
		virtual void mouseReleaseEvent(TQMouseEvent*);
		virtual void mouseMoveEvent(TQMouseEvent*);
		virtual void keyPressEvent(TQKeyEvent*);
		virtual void keyReleaseEvent(TQKeyEvent*);
	private:
		bool    mReadOnly;      // value cannot be changed
};

#endif // EMAILIDCOMBO_H
