/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef CONFIGURETABLEVIEWDIALOG_H
#define CONFIGURETABLEVIEWDIALOG_H

#include "viewconfigurewidget.h"

class TQString;
class TQWidget;
class TQRadioButton;
class TQCheckBox;
class KURLRequester;
class KConfig;

namespace KABC { class AddressBook; }

class LookAndFeelPage;

/**
  Configure dialog for the table view. This dialog inherits from the
  standard view dialog in order to add a custom page for the table
  view.
 */
class ConfigureTableViewWidget : public ViewConfigureWidget
{
  public:
    ConfigureTableViewWidget( KABC::AddressBook *ab, TQWidget *parent, const char *name );
    virtual ~ConfigureTableViewWidget();

    virtual void restoreSettings( KConfig* );
    virtual void saveSettings( KConfig* );

  private:
    void initGUI();

    LookAndFeelPage *mPage;
};

/**
  Internal class. It is only defined here for moc
*/
class LookAndFeelPage : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT

  public:
    LookAndFeelPage( TQWidget *parent, const char *name = 0 );
    ~LookAndFeelPage() {}

    void restoreSettings( KConfig* );
    void saveSettings( KConfig* );

  protected slots:
    void enableBackgroundToggled( bool );

  private:
    void initGUI();

    TQRadioButton *mAlternateButton;
    TQRadioButton *mLineButton;
    TQRadioButton *mNoneButton;
    TQCheckBox *mToolTipBox;
    KURLRequester *mBackgroundName;
    TQCheckBox *mBackgroundBox;
    TQCheckBox *mIMPresenceBox;
};

#endif
