/* -*- Mode: C++ -*-
   KD Tools - a set of useful widgets for TQt
*/

/****************************************************************************
** Copyright (C) 2005 Klarlvdalens Datakonsult AB.  All rights reserved.
**
** This file is part of the KD Tools library.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid commercial KD Tools licenses may use this file in
** accordance with the KD Tools Commercial License Agreement provided with
** the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.klaralvdalens-datakonsult.se/?page=products for
**   information about KD Tools Commercial License Agreements.
**
** Contact info@klaralvdalens-datakonsult.se if any conditions of this
** licensing are not clear to you.
**
** In addition, as a special exception, the copyright holders give
** permission to link the code of this program with any edition of the
** TQt library by Trolltech AS, Norway (or with modified versions of TQt
** that use the same license as TQt), and distribute linked
** combinations including the two.  You must obey the GNU General
** Public License in all respects for all of the code used other than
** TQt.  If you modify this file, you may extend this exception to your
** version of the file, but you are not obligated to do so.  If you do
** not wish to do so, delete this exception statement from your
** version.
**
**********************************************************************/

#include "kdhorizontalline.h"

#include <tqstyle.h>
#include <tqpainter.h>
#ifdef TQT_ACCESSIBILITY_SUPPORT
#include <tqaccessible.h>
#endif
#include <tqfontmetrics.h>
#include <tqapplication.h>

KDHorizontalLine::KDHorizontalLine( TQWidget * parent, const char * name, WFlags f )
  : TQFrame( parent, name, f ),
    mAlign( TQt::AlignAuto ),
    mLenVisible( 0 )
{
  TQFrame::setFrameStyle( HLine | Sunken );
}

KDHorizontalLine::KDHorizontalLine( const TQString & title, TQWidget * parent, const char * name, WFlags f )
  : TQFrame( parent, name, f ),
    mAlign( TQt::AlignAuto ),
    mLenVisible( 0 )
{
  TQFrame::setFrameStyle( HLine | Sunken );
  setTitle( title );
}

KDHorizontalLine::~KDHorizontalLine() {}

void KDHorizontalLine::setFrameStyle( int style ) {
  TQFrame::setFrameStyle( ( style & ~MShape ) | HLine ); // force HLine
}

void KDHorizontalLine::setTitle( const TQString & title ) {
  if ( mTitle == title )
    return;
  mTitle = title;
  calculateFrame();
  update();
  updateGeometry();
#ifdef TQT_ACCESSIBILITY_SUPPORT
  TQAccessible::updateAccessibility( this, 0, TQAccessible::NameChanged );
#endif
}

void KDHorizontalLine::calculateFrame() {
  mLenVisible = mTitle.length();
#if 0
  if ( mLenVisible ) {
    const TQFontMetrics fm = fontMetrics();
    while ( mLenVisible ) {
      const int tw = fm.width( mTitle, mLenVisible ) + 4*fm.width(TQChar(' '));
      if ( tw < width() )
        break;
      mLenVisible--;
    }
    qDebug( "mLenVisible = %d (of %d)", mLenVisible, mTitle.length() );
    if ( mLenVisible ) { // but do we also have a visible label?
      TQRect r = rect();
      const int va = style().styleHint( TQStyle::SH_GroupBox_TextLabelVerticalAlignment, this );
      if( va & AlignVCenter )
        r.setTop( fm.height() / 2 );		// frame rect should be
      else if( va & AlignTop )
        r.setTop( fm.ascent() );
      setFrameRect( r );			//   smaller than client rect
      return;
    }
  }
  // no visible label
  setFrameRect( TQRect(0,0,0,0) );		//  then use client rect
#endif
}

TQSizePolicy KDHorizontalLine::sizePolicy() const {
  return TQSizePolicy( TQSizePolicy::Minimum, TQSizePolicy::Fixed );
}

TQSize KDHorizontalLine::sizeHint() const {
  return minimumSizeHint();
}

TQSize KDHorizontalLine::minimumSizeHint() const {
  const int w = fontMetrics().width( mTitle, mLenVisible ) +
                fontMetrics().width( TQChar( ' ' ) );
  const int h = fontMetrics().height();
  return TQSize( TQMAX( w, indentHint() ), h ).expandedTo( tqApp->globalStrut() );
}

void KDHorizontalLine::paintEvent( TQPaintEvent * e ) {
  TQPainter paint( this );

  if ( mLenVisible ) {	// draw title
    const TQFontMetrics & fm = paint.fontMetrics();
    const int h = fm.height();
    const int tw = fm.width( mTitle, mLenVisible ) + fm.width(TQChar(' '));
    int x;
    if ( mAlign & AlignHCenter )		// center alignment
      x = frameRect().width()/2 - tw/2;
    else if ( mAlign & AlignRight )	// right alignment
      x = frameRect().width() - tw;
    else if ( mAlign & AlignLeft )       // left alignment
      x = 0;
    else { // auto align
      if( TQApplication::reverseLayout() )
        x = frameRect().width() - tw;
      else
        x = 0;
    }
    TQRect r( x, 0, tw, h );
    int va = style().styleHint( TQStyle::SH_GroupBox_TextLabelVerticalAlignment, this );
    if ( va & AlignTop )
      r.moveBy( 0, fm.descent() );
    const TQColor pen( (TQRgb) style().styleHint( TQStyle::SH_GroupBox_TextLabelColor, this ) );
    if ( !style().styleHint( TQStyle::SH_UnderlineAccelerator, this ) )
      va |= NoAccel;
    style().drawItem( &paint, r, ShowPrefix | AlignHCenter | va, colorGroup(),
                      isEnabled(), 0, mTitle, -1, ownPalette() ? 0 : &pen );
    paint.setClipRegion( e->region().subtract( r ) ); // clip everything but title
  }
  drawFrame( &paint );
  drawContents( &paint );
}

// static
int KDHorizontalLine::indentHint() {
  return 30;
}

#include "kdhorizontalline.moc"
