/*
    This file is part of Akregator.

    Copyright (C) 2004 Frank Osterfeld <frank.osterfeld at kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef AKREGATOR_OPTIONS_H
#define AKREGATOR_OPTIONS_H

#include <kcmdlineargs.h>
#include <klocale.h>

namespace Akregator {

static KCmdLineOptions akregator_options[] =
{
	{ "a", 0, 0 },
	{ "addfeed <url>", I18N_NOOP( "Add a feed with the given URL" ), 0},
	{ "g", 0, 0 },
	{ "group <groupname>", I18N_NOOP( "When adding feeds, place them in this group" ), I18N_NOOP("Imported") },
    { "hide-mainwindow", I18N_NOOP( "Hide main window on startup" ), 0},
	KCmdLineLastOption
};

}

#endif
