/*
  $ Author: Mirko Boehm $
  $ License: This code is licensed under the LGPL $
  $ Copyright: (C) 1996-2003, Mirko Boehm $
  $ Contact: Mirko Boehm <mirko@kde.org>
         http://www.kde.org
         http://www.hackerbuero.org $
*/

#ifndef KWIRELESS_PROPERTYTABLE_H
#define KWIRELESS_PROPERTYTABLE_H

#include <kdialogbase.h>
#include <tqptrlist.h>
#include "propertytablebase.h"

class DeviceInfo;
class TQTimer;

class PropertyTable : public PropertyTableBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    PropertyTable(TQWidget *parent = 0, const char* name = 0);
    ~PropertyTable();
};


class PropertiesDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    PropertiesDialog(TQWidget *parent = 0, const char *name = 0);
protected:
    PropertyTable *table;
    TQPtrList<DeviceInfo> *info;
    bool wait;
    TQTimer *timer;
public slots:
    void update(TQPtrList<DeviceInfo> *);
    void timeout();
    void selected(int);
};

#endif // KWIRELESS_PROPERTYTABLE_H
