#ifndef OBJFINGER_H
#define OBJFINGER_H

#include <tqobject.h>
#include <tqdict.h>
#include <tqstringlist.h>

class objFinder : public TQObject {
  Q_OBJECT
  TQ_OBJECT
public:

  objFinder();
  virtual ~objFinder();
    
  static void insert(TQObject *obj, const char *key = 0);
  static TQObject *find(const char *name, const char *inherits);
  static void dumpTree();
  static TQStringList allObjects();

signals:
  void inserted(TQObject *obj);
  
protected slots:
  void objDest();

private:
  /*
   * Don't allow the object to be created, all it's members are static
   */

  static TQString randString();

  
  static TQDict<TQObject> *objList;
    
};

extern objFinder *objFind;

#endif

