#ifndef KSIRCPROCESS
#define KSIRCPROCESS

class KSircProcess;
class KSircTopLevel;

#include <tqdict.h>
#include <tqobject.h>

#include "iocontroller.h"
#include "ksircserver.h"
#include "ksircchannel.h"

class KProcess;
class KSircIOController;
class KSircMessageReceiver;
class KSircIOController;

class KSircProcess : public TQObject
{
  Q_OBJECT
  TQ_OBJECT
  friend class KSircIOController;
public:
  KSircProcess(TQString &server_id, KSircServer &kss, TQObject * parent=0, const char * name=0);
  virtual ~KSircProcess();

  TQDict<KSircMessageReceiver> &getWindowList()
    {
      return TopList;
    }

  TQPtrList<KSircMessageReceiver> messageReceivers() const;
  const TQDict<KSircMessageReceiver> &mrList() const;

  TQString serverName() const { return m_kss.server(); }
  TQString serverPort() const { return m_kss.port(); }
  TQString serverID() const { return m_serverid; }

  KSircIOController *getIOController() { return iocontrol; }

  const TQString getNick() const;
  void setNick(const TQString nick);


signals:
  void ProcMessage(TQString, int, TQString);

public slots:
 virtual void ServMessage(TQString server, int command, TQString args);
 virtual void close_toplevel(KSircTopLevel *, TQString);
 virtual void default_window(KSircTopLevel *);
 virtual void recvChangeChannel(const TQString &, const TQString &);
 virtual void new_toplevel(const KSircChannel &, bool safe = false);

 virtual void filters_update();

 virtual void notify_forw_online(TQString);
 virtual void notify_forw_offline(TQString);

protected slots:
  virtual void clean_toplevel(TQObject *clean);
  virtual void request_quit( const TQCString& command );
  virtual void do_quit();

  virtual void turn_on_autocreate();


private:
  void base_filters();
  void cleanup();

  KSircIOController *iocontrol;
  KProcess *proc;

  TQDict<KSircMessageReceiver> TopList;

  bool running_window;
  bool default_follow_focus;
  bool auto_create_really;

  KSircServer m_kss;
  const TQString m_serverid;

  /*
   * m_nick is our nick as reported by the lower levels
   */
  TQString m_nick;

//  char *server;
};

#endif
