/***************************************************************************
                          trayicon.h  -  description
                             -------------------
    begin                : Tue Dec 11 2001
    copyright            : (C) 2001-2002 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRAYICON_H
#define TRAYICON_H

#include "configuration.h"

#include <tqwidget.h>
#include <kpixmap.h>
#include <kaction.h>
#include <ksystemtray.h>
#include <kpassivepopup.h>

class KDialog;

class KPassivePopup2 : public KPassivePopup {
   	Q_OBJECT
  TQ_OBJECT
public: 
        KPassivePopup2(TQWidget *parent);
        static KPassivePopup2 *message( const TQString &caption, const TQString &text,
					const TQPixmap &icon,
					TQWidget *parent);

signals:
	void hidden();

protected:
        /**
         * Reimplemented to detect hide events.
         */
        virtual void hideEvent( TQHideEvent *e );
};

/**
  * Implements the trayicon. 
  * @author Tim Jansen
  */

class TrayIcon : public KSystemTray {
   	Q_OBJECT
  TQ_OBJECT
public: 
	TrayIcon(KDialog*, Configuration*);
	~TrayIcon();

signals:
	void showManageInvitations();
	void diconnectedMessageDisplayed();
	void enableDesktopControl(bool);

public slots:
        void prepareQuit();
        void showConnectedMessage(TQString host);
        void showDisconnectedMessage();
	void setDesktopControlSetting(bool);

protected:
	void mousePressEvent(TQMouseEvent *e);

private:

  	KPixmap trayIconOpen;
  	KPixmap trayIconClosed;
	Configuration *configuration;
	KDialog* aboutDialog;
	KActionCollection actionCollection;
  	KAction* manageInvitationsAction;
  	KAction* aboutAction;
	KToggleAction* enableControlAction;
	bool quitting;

private slots:
	void showAbout();
};

#endif
