/***************************************************************************
                          threads.h  -  threads for kvncview
                             -------------------
    begin                : Thu May 09 16:01:42 CET 2002
    copyright            : (C) 2002 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THREADS_H
#define THREADS_H

#include <tqthread.h>
#include <tqregion.h>
#include <tqrect.h>
#include <tqmutex.h>
#include <tqwaitcondition.h>
#include <tqevent.h>
#include <tqvaluelist.h>
#include <tqdatetime.h>

#include <stdlib.h> 

#include "events.h"
#include "vnctypes.h"

class KVncView;

enum EventType {
	MouseEventType,
	KeyEventType
};


struct MouseEvent {
	int x, y, buttons;
};

struct KeyEvent {
	unsigned int k;
	bool down;
};

struct InputEvent {
	EventType type;
	union {
		MouseEvent m;
		KeyEvent k;
	} e;
};


class WriterThread : public TQThread {
private:
	TQMutex m_lock;
	TQWaitCondition m_waiter;
	volatile bool &m_quitFlag;
	KVncView *m_view;

	TQTime m_lastIncrUpdate; // start()ed when a incr update is sent
	bool m_lastIncrUpdatePostponed;

	// all things that can be send follow:
	bool m_incrementalUpdateRQ; // for sending an incremental request
	bool m_incrementalUpdateAnnounced; // set when a RQ will come soon
	TQRegion m_updateRegionRQ;  // for sending updates, null if it is done
	TQValueList<InputEvent> m_inputEvents; // list of unsent input events
	MouseEvent m_lastMouseEvent;
	int m_mouseEventNum, m_keyEventNum;
	TQString m_clientCut;

	void sendFatalError(ErrorCode s);

public:
	WriterThread(KVncView *v, volatile bool &quitFlag);
	
	void queueIncrementalUpdateRequest();
	void announceIncrementalUpdateRequest();
	void queueUpdateRequest(const TQRegion &r);
	void queueMouseEvent(int x, int y, int buttonMask);
	void queueKeyEvent(unsigned int k, bool down);
	void queueClientCut(const TQString &text);
	void kick();
	
protected:
	void run();
	bool sendIncrementalUpdateRequest();
	bool sendUpdateRequest(const TQRegion &r);
	bool sendInputEvents(const TQValueList<InputEvent> &events);
};



class ControllerThread : public TQThread { 
private:
	KVncView *m_view;
	enum RemoteViewStatus m_status;
	WriterThread &m_wthread;
	volatile bool &m_quitFlag;
	volatile bool m_desktopInitialized;
	TQWaitCondition m_waiter;

	void changeStatus(RemoteViewStatus s);
	void sendFatalError(ErrorCode s);

public:
	ControllerThread(KVncView *v, WriterThread &wt, volatile bool &quitFlag);
	enum RemoteViewStatus status();	
	void desktopInit();
	void kick();

protected:
	void run();
};



#endif
